-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Erstellungszeit: 20. Okt 2025 um 08:23
-- Server-Version: 10.4.32-MariaDB
-- PHP-Version: 8.2.12
Create DataBase if not Exists versandhandel;
use versandhandel;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Datenbank: `versandhandel`
--

DELIMITER $$
--
-- Prozeduren
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `bestellStatistikCursorWithName` ()   BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE k_id INT;
    DECLARE k_name VARCHAR(45);
    DECLARE k_vorname VARCHAR(45);
    DECLARE anzahl INT;

    DECLARE cur CURSOR FOR 
        SELECT kunden_id, name, vorname FROM kunden;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    -- TEMPORÄRE TABELLE FÜR AUSGABE
    CREATE TEMPORARY TABLE IF NOT EXISTS kunden_statistik (
        kunden_id INT,
        name VARCHAR(45),
        vorname VARCHAR(45),
        anzahl_bestellungen INT
    );

    OPEN cur;

    read_loop: LOOP
        FETCH cur INTO k_id, k_name, k_vorname;
        IF done THEN
            LEAVE read_loop;
        END IF;

        -- Zähle Bestellungen für aktuellen Kunden
        SELECT COUNT(*) INTO anzahl 
        FROM bestellungen 
        WHERE kunden_id = k_id;

        INSERT INTO kunden_statistik(kunden_id, name, vorname, anzahl_bestellungen)
        VALUES (k_id, k_name, k_vorname, anzahl);
    END LOOP;

    CLOSE cur;

    -- ZEIGE ERGEBNIS
    SELECT * FROM kunden_statistik ORDER BY anzahl_bestellungen DESC;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `bestellStatistikCursorWithSumme` ()   BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE k_id INT;
    DECLARE k_name VARCHAR(45);
    DECLARE k_vorname VARCHAR(45);
    DECLARE anzahl INT;
    DECLARE summe DECIMAL(10,2);

    DECLARE cur CURSOR FOR 
        SELECT kunden_id, name, vorname FROM kunden;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    -- TEMPORÄRE TABELLE FÜR AUSGABE
    CREATE TEMPORARY TABLE IF NOT EXISTS kunden_statistik (
        kunden_id INT,
        name VARCHAR(45),
        vorname VARCHAR(45),
        anzahl_bestellungen INT,
        gesamtsumme DECIMAL(10,2)
    );

    OPEN cur;

    read_loop: LOOP
        FETCH cur INTO k_id, k_name, k_vorname;
        IF done THEN
            LEAVE read_loop;
        END IF;

        -- Zähle Bestellungen für aktuellen Kunden
        SELECT COUNT(*), SUM(p.preis) INTO anzahl, summe
        FROM bestellungen b
        LEFT JOIN positionen p ON b.bestellungen_id = p.bestellungen_id 
        WHERE b.kunden_id = k_id;

        INSERT INTO kunden_statistik(kunden_id, name, vorname, anzahl_bestellungen, gesamtsumme)
        VALUES (k_id, k_name, k_vorname, anzahl, summe);
    END LOOP;

    CLOSE cur;

    -- ZEIGE ERGEBNIS
    SELECT * FROM kunden_statistik ORDER BY anzahl_bestellungen, gesamtsumme DESC;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `getBestellungenByKunde` (IN `kunde_id` INT)   BEGIN
    SELECT b.bestellungen_id, b.datum
    FROM bestellungen b
    WHERE b.kunden_id = kunde_id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `getBestellungenByKundeUndArtikel` (IN `kunde_id` INT)   BEGIN
    SELECT p.positionen_id, pr.artikel, b.bestellungen_id, b.datum
    FROM bestellungen b
    LEFT JOIN positionen p ON b.bestellungen_id = p.bestellungen_id
    LEFT JOIN produkte pr ON pr.produkte_id = p.produkt_id
    WHERE b.kunden_id = kunde_id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `lagerbestandsWarnung` (IN `mindestbestand` INT)   BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE produkt_id INT;
    DECLARE artikel_name VARCHAR(255);
    DECLARE aktueller_bestand INT;
    DECLARE kategorie_name VARCHAR(100);
    DECLARE produkt_preis DECIMAL(10,2);
    DECLARE verkaufs_haeufigkeit INT;
    DECLARE durchschnitt_lieferzeit DECIMAL(5,2);
    DECLARE empfohlene_menge INT;
    DECLARE sicherheitspuffer INT DEFAULT 10; -- Zusätzlicher Puffer in Tagen
    
    -- Cursor für kritische Produkte (unter Mindestbestand)
    DECLARE kritische_produkte_cursor CURSOR FOR
        SELECT 
            p.produkte_id,
            p.artikel,
            p.lagerbestand,
            p.preis,
            COALESCE(k.bezeichnung, 'Unbekannt') as kategorie
        FROM produkte p
        LEFT JOIN kategorien k ON p.kategorie_id = k.kategorie_id
        WHERE p.lagerbestand < mindestbestand
        ORDER BY p.lagerbestand ASC;
    
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
    
    -- Temporäre Tabelle für die Ergebnisse erstellen
    DROP TEMPORARY TABLE IF EXISTS lagerbestand_warnung_ergebnis;
    CREATE TEMPORARY TABLE lagerbestand_warnung_ergebnis (
        produkt_id INT,
        artikel VARCHAR(255),
        kategorie VARCHAR(100),
        aktueller_bestand INT,
        mindest_bestand INT,
        preis DECIMAL(10,2),
        verkaufs_haeufigkeit_6m INT,
        durchschnitt_verkauf_pro_monat DECIMAL(8,2),
        durchschnitt_lieferzeit_tage DECIMAL(5,2),
        empfohlene_nachbestellung INT,
        begruendung TEXT,
        prioritaet ENUM('KRITISCH', 'HOCH', 'MITTEL', 'NIEDRIG'),
        geschaetzter_wert DECIMAL(12,2)
    );
    
    -- Durchschnittliche Lieferzeit für alle Bestellungen berechnen
    SELECT 
        COALESCE(AVG(DATEDIFF(l.versand_datum, b.datum)), 3.0)
    INTO durchschnitt_lieferzeit
    FROM bestellungen b
    INNER JOIN lieferungen l ON b.bestellungen_id = l.bestellungen_id
    WHERE l.versand_datum IS NOT NULL;
    
    OPEN kritische_produkte_cursor;
    
    kritische_produkte_loop:LOOP
        FETCH kritische_produkte_cursor INTO 
            produkt_id, artikel_name, aktueller_bestand, produkt_preis, kategorie_name;
            
        IF done THEN
            LEAVE kritische_produkte_loop;
        END IF;
        
        -- Verkaufshäufigkeit der letzten 6 Monate berechnen
        SELECT 
            COALESCE(SUM(pos.menge), 0)
        INTO verkaufs_haeufigkeit
        FROM positionen pos
        INNER JOIN bestellungen b ON pos.bestellungen_id = b.bestellungen_id
        WHERE pos.produkt_id = produkt_id
        AND b.datum >= DATE_SUB(NOW(), INTERVAL 6 MONTH);
        
        -- Empfohlene Nachbestellmenge berechnen
        -- Formel: (Durchschnittlicher Monatsbedarf * (Lieferzeit in Monaten + Sicherheitspuffer)) - aktueller Bestand
        SET empfohlene_menge = GREATEST(
            CEIL(
                (verkaufs_haeufigkeit / 6.0) * -- Durchschnitt pro Monat
                ((durchschnitt_lieferzeit + sicherheitspuffer) / 30.0) * 2 -- Lieferzeit + Puffer in Monaten, * 2 für Sicherheit
            ) - aktueller_bestand,
            mindestbestand - aktueller_bestand -- Mindestens bis zum Mindestbestand auffüllen
        );
        
        -- Priorität basierend auf Bestand und Verkaufsgeschwindigkeit festlegen
        SET @prioritaet = CASE
            WHEN aktueller_bestand = 0 THEN 'KRITISCH'
            WHEN aktueller_bestand <= (mindestbestand * 0.3) AND verkaufs_haeufigkeit > 0 THEN 'KRITISCH'
            WHEN aktueller_bestand <= (mindestbestand * 0.5) THEN 'HOCH'
            WHEN verkaufs_haeufigkeit > (mindestbestand * 0.5) THEN 'HOCH'
            WHEN aktueller_bestand <= (mindestbestand * 0.8) THEN 'MITTEL'
            ELSE 'NIEDRIG'
        END;
        
        -- Begründung für die Empfehlung erstellen
        SET @begruendung = CONCAT(
            'Aktueller Bestand (', aktueller_bestand, ') unter Mindestbestand (', mindestbestand, '). ',
            'Verkäufe letzte 6 Monate: ', verkaufs_haeufigkeit, ' Stück. ',
            'Ø Verkauf/Monat: ', ROUND(verkaufs_haeufigkeit / 6.0, 2), '. ',
            'Ø Lieferzeit: ', ROUND(durchschnitt_lieferzeit, 1), ' Tage. ',
            CASE 
                WHEN verkaufs_haeufigkeit = 0 THEN 'Keine Verkäufe - prüfen ob Artikel noch relevant.'
                WHEN verkaufs_haeufigkeit > 10 THEN 'Hohe Nachfrage - dringend nachbestellen!'
                ELSE 'Moderate Nachfrage - Nachbestellung empfohlen.'
            END
        );
        
        -- Ergebnis in temporäre Tabelle einfügen
        INSERT INTO lagerbestand_warnung_ergebnis VALUES (
            produkt_id,
            artikel_name,
            kategorie_name,
            aktueller_bestand,
            mindestbestand,
            produkt_preis,
            verkaufs_haeufigkeit,
            ROUND(verkaufs_haeufigkeit / 6.0, 2),
            durchschnitt_lieferzeit,
            empfohlene_menge,
            @begruendung,
            @prioritaet,
            ROUND(empfohlene_menge * produkt_preis, 2)
        );
        
    END LOOP;
    
    CLOSE kritische_produkte_cursor;
    
    -- Ergebnisse ausgeben, sortiert nach Priorität und dann nach geschätztem Wert
    SELECT 
        produkt_id as 'Produkt ID',
        artikel as 'Artikel',
        kategorie as 'Kategorie',
        aktueller_bestand as 'Aktueller Bestand',
        mindest_bestand as 'Mindest-Bestand',
        CONCAT('€ ', FORMAT(preis, 2)) as 'Preis pro Stück',
        verkaufs_haeufigkeit_6m as 'Verkäufe 6M',
        durchschnitt_verkauf_pro_monat as 'Ø Verkauf/Monat',
        CONCAT(ROUND(durchschnitt_lieferzeit_tage, 1), ' Tage') as 'Ø Lieferzeit',
        empfohlene_nachbestellung as 'Empfohlene Nachbestellung',
        CONCAT('€ ', FORMAT(geschaetzter_wert, 2)) as 'Geschätzter Bestellwert',
        prioritaet as 'Priorität',
        begruendung as 'Begründung'
    FROM lagerbestand_warnung_ergebnis
    ORDER BY 
        CASE prioritaet 
            WHEN 'KRITISCH' THEN 1 
            WHEN 'HOCH' THEN 2 
            WHEN 'MITTEL' THEN 3 
            WHEN 'NIEDRIG' THEN 4 
        END,
        geschaetzter_wert DESC;
    
    -- Zusammenfassung ausgeben
    SELECT 
        'ZUSAMMENFASSUNG' as '═══ LAGERBESTAND WARNUNG ═══',
        '' as '';
        
    SELECT 
        COUNT(*) as 'Anzahl kritische Produkte',
        SUM(CASE WHEN prioritaet = 'KRITISCH' THEN 1 ELSE 0 END) as 'Davon KRITISCH',
        SUM(CASE WHEN prioritaet = 'HOCH' THEN 1 ELSE 0 END) as 'Davon HOCH',
        SUM(CASE WHEN prioritaet = 'MITTEL' THEN 1 ELSE 0 END) as 'Davon MITTEL',
        SUM(CASE WHEN prioritaet = 'NIEDRIG' THEN 1 ELSE 0 END) as 'Davon NIEDRIG',
        CONCAT('€ ', FORMAT(SUM(geschaetzter_wert), 2)) as 'Gesamt Bestellwert'
    FROM lagerbestand_warnung_ergebnis;
    
    -- Top 5 kritischste Produkte nach Wert
    SELECT 
        'TOP 5 KRITISCHE PRODUKTE' as '═══ PRIORITÄTENLISTE ═══',
        '' as '';
        
    SELECT 
        artikel as 'Artikel',
        aktueller_bestand as 'Bestand',
        empfohlene_nachbestellung as 'Nachbestellen',
        CONCAT('€ ', FORMAT(geschaetzter_wert, 2)) as 'Wert',
        prioritaet as 'Priorität'
    FROM lagerbestand_warnung_ergebnis
    WHERE prioritaet IN ('KRITISCH', 'HOCH')
    ORDER BY 
        CASE prioritaet WHEN 'KRITISCH' THEN 1 WHEN 'HOCH' THEN 2 END,
        geschaetzter_wert DESC
    LIMIT 5;

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `mysecondproc` ()   BEGIN

Select * From kunden WHERE vorname LIKE Concat('A','%');

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `my_zufallszahl` ()   BEGIN
DECLARE zufall decimal(10,8);
Set zufall=rand();
Select floor(zufall*6)+1;
select zufall;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `neueBestellung` (IN `kundeId` INT, IN `datum` DATETIME, OUT `neueBestellId` INT)   BEGIN
    INSERT INTO bestellungen (kunden_id, datum) VALUES (kundeId, datum);
    SET neueBestellId = LAST_INSERT_ID();
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `parameter_vs_session_demo` (IN `eingabe_wert` INT, OUT `ausgabe_wert` INT)   BEGIN
    DECLARE lokale_variable INT;   -- Lokale Variable: Nur in dieser Prozedur
    
    SET lokale_variable = eingabe_wert * 2;     -- Lokale Berechnung
    SET ausgabe_wert = lokale_variable;         -- Parameter setzen
    SET @session_variable = lokale_variable;    -- Session-Variable setzen
    
    -- Am Ende der Prozedur:
    -- - lokale_variable verschwindet
    -- - eingabe_wert und ausgabe_wert verschwinden  
    -- - @session_variable bleibt bestehen!
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `zinsen_berechnen` (IN `startkapital` DECIMAL(10,2), IN `jahre` INT, IN `zinssatz` DECIMAL(3,2))   BEGIN
    DECLARE aktuelles_kapital DECIMAL(10,2);
    DECLARE jahr_counter INT;
    
    SET aktuelles_kapital = startkapital;
    SET jahr_counter = 1;
    -- TEMPORÄRE TABELLE FÜR AUSGABE
    CREATE TEMPORARY TABLE IF NOT EXISTS zins_log (
        yearcounter INT,
        capital DECIMAL(10,2),
        jetzt TIMESTAMP);
    WHILE jahr_counter <= jahre DO
        SET aktuelles_kapital = aktuelles_kapital+(aktuelles_kapital * (1 + zinssatz)/100);
        INSERT INTO zins_log VALUES (jahr_counter, aktuelles_kapital, NOW());
        SET jahr_counter = jahr_counter + 1;
    END WHILE;
END$$

--
-- Funktionen
--
CREATE DEFINER=`root`@`localhost` FUNCTION `einfacher_rabatt` (`preis` DECIMAL(10,2)) RETURNS DECIMAL(10,2) READS SQL DATA BEGIN
    RETURN preis * 0.9; -- 10% Rabatt
END$$

CREATE DEFINER=`root`@`localhost` FUNCTION `function_zufall` () RETURNS INT(11)  BEGIN
	DECLARE zufall DECIMAL(10,2);
	set zufall =rand();
    RETURN floor(zufall*6)+1;
END$$

CREATE DEFINER=`root`@`localhost` FUNCTION `unterschiedlicher_rabatt` (`preis` DECIMAL(10,2)) RETURNS DECIMAL(10,2)  BEGIN
  if preis < 500 then
      RETURN preis * 0.9; -- 10% Rabatt
  else 
      return preis * 0.8;
  end if;    
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `bestellungen`
--

CREATE TABLE `bestellungen` (
  `bestellungen_id` int(255) NOT NULL,
  `kunden_id` int(10) UNSIGNED NOT NULL,
  `datum` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Daten für Tabelle `bestellungen`
--

INSERT INTO `bestellungen` (`bestellungen_id`, `kunden_id`, `datum`) VALUES
(1, 1, '2025-07-09 09:46:44'),
(2, 47, '2024-07-13 12:28:39'),
(3, 43, '2024-03-06 01:59:46'),
(4, 32, '2024-02-21 23:11:00'),
(5, 38, '2024-09-27 14:30:33'),
(6, 17, '2024-04-28 17:59:04'),
(7, 2, '2024-10-18 14:42:34'),
(8, 2, '2024-08-08 20:04:28'),
(9, 35, '2024-04-01 06:35:52'),
(10, 54, '2024-07-23 07:05:00'),
(11, 22, '2024-07-11 20:54:56'),
(12, 14, '2024-06-19 09:30:50'),
(13, 25, '2025-02-19 15:50:27'),
(14, 29, '2024-05-13 12:11:20'),
(15, 39, '2024-01-03 20:42:35'),
(16, 41, '2024-05-15 09:32:07'),
(17, 29, '2024-01-05 00:02:19'),
(18, 11, '2024-01-27 15:23:12'),
(19, 7, '2024-11-18 10:58:25'),
(20, 26, '2024-08-22 15:07:43'),
(21, 30, '2024-05-06 06:54:40'),
(22, 7, '2024-10-17 05:04:06'),
(23, 25, '2024-05-07 02:40:13'),
(24, 13, '2025-04-24 03:35:39'),
(25, 27, '2024-10-15 17:06:08'),
(26, 40, '2025-05-13 06:13:07'),
(27, 39, '2024-02-25 19:54:34'),
(28, 30, '2024-04-06 09:43:17'),
(29, 24, '2025-01-17 10:12:19'),
(30, 3, '2024-10-23 17:25:03'),
(31, 23, '2025-01-09 11:40:20'),
(32, 10, '2025-02-06 12:58:13'),
(33, 54, '2025-02-12 08:19:48'),
(34, 3, '2025-05-04 04:58:47'),
(35, 39, '2024-05-04 08:54:50'),
(36, 40, '2024-01-11 12:21:49'),
(37, 12, '2025-03-23 19:51:04'),
(38, 13, '2024-08-12 18:52:59'),
(39, 13, '2025-03-02 10:16:14'),
(40, 27, '2024-07-31 13:42:30'),
(41, 46, '2024-06-14 11:12:48'),
(42, 5, '2025-04-19 14:03:19'),
(43, 27, '2025-05-07 03:40:34'),
(44, 39, '2025-01-18 16:09:47'),
(45, 13, '2025-05-12 19:57:35'),
(46, 22, '2025-01-26 20:32:13'),
(47, 7, '2025-05-22 12:29:44'),
(48, 15, '2025-02-17 12:25:49'),
(49, 2, '2024-01-07 16:56:21'),
(50, 50, '2025-05-26 14:52:11'),
(51, 30, '2024-10-06 12:56:20'),
(52, 46, '2025-02-07 16:35:58'),
(53, 20, '2024-08-09 04:53:10'),
(54, 37, '2025-03-02 02:01:16'),
(55, 4, '2024-06-07 17:11:00'),
(56, 54, '2025-06-20 20:00:00'),
(57, 3, '2025-05-11 20:00:00'),
(58, 11, '2025-03-10 22:00:00'),
(59, 15, '2025-01-15 09:30:00'),
(60, 28, '2025-01-18 13:22:15'),
(61, 42, '2025-01-22 08:45:30'),
(62, 6, '2025-01-25 15:18:45'),
(63, 33, '2025-01-28 10:30:22'),
(64, 19, '2025-02-02 12:45:18'),
(65, 51, '2025-02-05 07:22:33'),
(66, 8, '2025-02-08 14:55:12'),
(67, 36, '2025-02-12 11:18:45'),
(68, 44, '2025-02-15 08:33:28'),
(69, 16, '2025-02-18 13:47:19'),
(70, 52, '2025-02-22 10:15:36'),
(71, 9, '2025-02-25 15:22:44'),
(72, 31, '2025-02-28 09:55:17'),
(73, 45, '2025-03-03 12:28:55'),
(74, 18, '2025-03-06 08:44:33'),
(75, 53, '2025-03-10 14:17:28'),
(76, 21, '2025-03-13 11:33:41'),
(77, 48, '2025-03-16 07:55:17'),
(78, 34, '2025-03-19 13:28:52'),
(79, 12, '2025-03-22 10:44:15'),
(80, 49, '2025-03-25 15:17:33'),
(81, 26, '2025-03-28 08:55:28'),
(82, 35, '2025-04-01 11:22:44'),
(83, 14, '2025-04-04 08:48:17'),
(84, 47, '2025-04-07 13:33:52'),
(85, 23, '2025-04-10 10:17:28'),
(86, 50, '2025-04-13 06:44:15'),
(87, 37, '2025-04-16 12:55:33'),
(88, 41, '2025-04-19 09:28:48'),
(89, 24, '2025-04-22 14:44:22'),
(90, 46, '2025-04-25 07:17:55'),
(91, 29, '2025-04-28 11:33:18'),
(92, 54, '2025-05-01 08:48:44'),
(93, 32, '2025-05-04 13:22:17'),
(94, 43, '2025-05-07 10:55:33'),
(95, 17, '2025-05-10 06:28:48'),
(96, 38, '2025-05-13 12:44:22'),
(97, 25, '2025-05-16 09:17:55'),
(98, 40, '2025-05-19 14:33:18'),
(99, 20, '2025-05-22 07:48:44'),
(100, 39, '2025-05-25 11:22:17'),
(101, 1, '2025-05-28 08:55:33'),
(102, 4, '2025-05-31 13:28:48'),
(103, 7, '2025-06-03 10:44:22'),
(104, 11, '2025-06-06 06:17:55'),
(105, 5, '2025-06-09 12:33:18'),
(106, 13, '2025-06-12 09:48:44'),
(107, 22, '2025-06-15 14:22:17'),
(108, 30, '2025-06-18 07:55:33');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `event_logs`
--

CREATE TABLE `event_logs` (
  `log_id` int(11) NOT NULL,
  `event_name` varchar(100) NOT NULL,
  `status` enum('ERFOLG','FEHLER','WARNUNG','INFO') NOT NULL DEFAULT 'INFO',
  `bemerkung` text DEFAULT NULL,
  `fehler_text` text DEFAULT NULL,
  `ausführung_zeit` timestamp NOT NULL DEFAULT current_timestamp(),
  `dauer_ms` int(11) DEFAULT NULL,
  `betroffene_datensätze` int(11) DEFAULT NULL,
  `output_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`output_data`)),
  `ausführung_id` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Stellvertreter-Struktur des Views `Haeufigkeit`
-- (Siehe unten für die tatsächliche Ansicht)
--
CREATE TABLE `Haeufigkeit` (
`Produktname` varchar(255)
,`Bestellhaeufigkeit` bigint(21)
,`preis` decimal(10,2)
);

-- --------------------------------------------------------

--
-- Stellvertreter-Struktur des Views `Häufigkeit`
-- (Siehe unten für die tatsächliche Ansicht)
--
CREATE TABLE `Häufigkeit` (
`Produktname` varchar(255)
,`Bestellhaeufigkeit` bigint(21)
,`preis` decimal(10,2)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `kategorien`
--

CREATE TABLE `kategorien` (
  `kategorie_id` int(11) NOT NULL,
  `bezeichnung` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Daten für Tabelle `kategorien`
--

INSERT INTO `kategorien` (`kategorie_id`, `bezeichnung`) VALUES
(1, 'Einzelteile'),
(2, 'Geräte'),
(3, 'Software'),
(4, 'Dienstleistung'),
(5, 'Zubehör');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `kunden`
--

CREATE TABLE `kunden` (
  `kunden_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `vorname` varchar(255) NOT NULL,
  `strasse` varchar(255) NOT NULL,
  `stadt` varchar(255) NOT NULL,
  `plz` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Daten für Tabelle `kunden`
--

INSERT INTO `kunden` (`kunden_id`, `name`, `vorname`, `strasse`, `stadt`, `plz`) VALUES
(1, 'Mustermann', 'Hans', 'Musterstrasse', 'Berlin', '10115'),
(2, 'Mustermann', 'Max', 'Musterstrasse 2', 'Berlin', '10117'),
(3, 'Mustermann', 'Ulrike', 'Musterstrasse', 'Berlin', '10119'),
(4, 'Meier', 'Klaus', 'Adalbertstrasse 18', 'München', '80331'),
(5, 'Schröder', 'Valentina', 'Dorfstraße 107', 'München', '80333'),
(6, 'Meyer', 'Xenia', 'Schulstraße 7', 'München', '80335'),
(7, 'Müller', 'Lukas', 'Hauptstraße 109', 'Köln', '50667'),
(8, 'Richter', 'Paul', 'Gartenweg 93', 'Hamburg', '20095'),
(9, 'Neumann', 'Valentina', 'Bergstraße 28', 'Hamburg', '20097'),
(10, 'Klein', 'Simon', 'Schillerstraße 114', 'Hamburg', '20099'),
(11, 'Meyer', 'Anna', 'Bahnhofstraße 101', 'Hamburg', '20144'),
(12, 'Schröder', 'Olivia', 'Dorfstraße 103', 'Hamburg', '20146'),
(13, 'Schulz', 'Olivia', 'Gartenweg 96', 'Berlin', '10178'),
(14, 'Braun', 'David', 'Gartenweg 37', 'Berlin', '10179'),
(15, 'Klein', 'Anna', 'Hauptstraße 22', 'Berlin', '10243'),
(16, 'Schwarz', 'Xenia', 'Ringstraße 21', 'Berlin', '10245'),
(17, 'Becker', 'Paul', 'Goethestraße 103', 'München', '80336'),
(18, 'Meyer', 'Simon', 'Bergstraße 82', 'München', '80337'),
(19, 'Schulz', 'Rosa', 'Gartenweg 52', 'München', '80339'),
(20, 'Richter', 'Paul', 'Gartenweg 47', 'Köln', '50668'),
(21, 'Zimmermann', 'Jonas', 'Bahnhofstraße 95', 'Köln', '50670'),
(22, 'Zimmermann', 'Ben', 'Schillerstraße 88', 'Köln', '50672'),
(23, 'Schulz', 'Eva', 'Ringstraße 28', 'Köln', '50674'),
(24, 'Schulz', 'Klara', 'Dorfstraße 48', 'Köln', '50676'),
(25, 'Fischer', 'Ben', 'Hauptstraße 95', 'Frankfurt', '60311'),
(26, 'Koch', 'Tina', 'Lindenweg 116', 'Frankfurt', '60313'),
(27, 'Schwarz', 'Klara', 'Hauptstraße 70', 'Frankfurt', '60314'),
(28, 'Wolf', 'Xenia', 'Hauptstraße 65', 'Frankfurt', '60316'),
(29, 'Richter', 'Jonas', 'Gartenweg 98', 'Frankfurt', '60318'),
(30, 'Braun', 'Nico', 'Gartenweg 120', 'Stuttgart', '70173'),
(31, 'Müller', 'Hannes', 'Gartenweg 64', 'Stuttgart', '70174'),
(32, 'Schulz', 'Ben', 'Goethestraße 53', 'Stuttgart', '70176'),
(33, 'Schmidt', 'Quirin', 'Ringstraße 34', 'Stuttgart', '70178'),
(34, 'Schneider', 'Nico', 'Bahnhofstraße 52', 'Stuttgart', '70180'),
(35, 'Schulz', 'Klara', 'Dorfstraße 94', 'Dresden', '01067'),
(36, 'Richter', 'Rosa', 'Gartenweg 25', 'Dresden', '01069'),
(37, 'Schwarz', 'Klara', 'Gartenweg 69', 'Dresden', '01097'),
(38, 'Wagner', 'Ben', 'Lindenweg 21', 'Dresden', '01099'),
(39, 'Müller', 'Jonas', 'Ringstraße 90', 'Leipzig', '04103'),
(40, 'Neumann', 'Hannes', 'Bahnhofstraße 68', 'Leipzig', '04105'),
(41, 'Müller', 'Lukas', 'Schillerstraße 8', 'Leipzig', '04107'),
(42, 'Braun', 'Jonas', 'Bahnhofstraße 89', 'Leipzig', '04109'),
(43, 'Koch', 'Anna', 'Hauptstraße 62', 'Düsseldorf', '40210'),
(44, 'Schwarz', 'Klara', 'Bahnhofstraße 100', 'Düsseldorf', '40211'),
(45, 'Weber', 'Wolfgang', 'Bergstraße 110', 'Düsseldorf', '40212'),
(46, 'Wolf', 'Klara', 'Schillerstraße 88', 'Düsseldorf', '40213'),
(47, 'Hoffmann', 'Greta', 'Gartenweg 8', 'Bremen', '28195'),
(48, 'Schneider', 'Anna', 'Schillerstraße 102', 'Bremen', '28197'),
(49, 'Bauer', 'Rosa', 'Dorfstraße 82', 'Bremen', '28199'),
(50, 'Klein', 'Zoe', 'Schulstraße 52', 'Hannover', '30159'),
(51, 'Schröder', 'Valentina', 'Schillerstraße 99', 'Hannover', '30161'),
(52, 'Schneider', 'Paul', 'Hauptstraße 32', 'Hannover', '30163'),
(53, 'Neumann', 'Isabel', 'Schulstraße 4', 'Nürnberg', '90402'),
(54, 'Schneider', 'Greta', 'Bahnhofstraße 33', 'Nürnberg', '90403'),
(55, 'Mustermann', 'Hans', 'Musterstraße', 'Berlin', '10247'),
(254, 'Martin', 'Franz', 'strasse', 'Köln', '50678');

--
-- Trigger `kunden`
--
DELIMITER $$
CREATE TRIGGER `neue_kunden_welcome` AFTER INSERT ON `kunden` FOR EACH ROW BEGIN
    -- Welcome-Eintrag erstellen
    INSERT INTO kunden_welcome_log(k_id,message,jetzt) VALUES (
        NEW.kunden_id,
        CONCAT('Willkommen ', NEW.name, '! Registriert am '),
        NOW()
    );
       
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `kunden_welcome_log`
--

CREATE TABLE `kunden_welcome_log` (
  `kw_id` int(11) NOT NULL,
  `k_id` int(11) NOT NULL,
  `message` varchar(255) NOT NULL,
  `jetzt` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Daten für Tabelle `kunden_welcome_log`
--

INSERT INTO `kunden_welcome_log` (`kw_id`, `k_id`, `message`, `jetzt`) VALUES
(3, 254, 'Willkommen Martin! Registriert am ', '2025-08-15 09:08:47');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `lieferungen`
--

CREATE TABLE `lieferungen` (
  `lieferungen_id` int(255) NOT NULL,
  `bestellungen_id` int(255) NOT NULL,
  `versand_datum` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Daten für Tabelle `lieferungen`
-- (Keine Lieferungen vorhanden - alle Bestellungen sind noch nicht ausgeliefert)
--

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `log_table`
--

CREATE TABLE `log_table` (
  `counter` int(11) NOT NULL,
  `produkte_id` int(11) DEFAULT NULL,
  `oldprice` decimal(10,2) DEFAULT NULL,
  `newprice` decimal(10,2) DEFAULT NULL,
  `jetzt` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Daten für Tabelle `log_table`
--

INSERT INTO `log_table` (`counter`, `produkte_id`, `oldprice`, `newprice`, `jetzt`) VALUES
(1, NULL, 39.90, 34.99, '2025-08-08 08:39:04'),
(2, 84, 34.99, 31.99, '2025-08-08 08:47:27'),
(3, 93, 149.00, 199.00, '2025-08-11 08:35:49'),
(4, 5, 139.46, 199.00, '2025-08-11 08:36:45');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `positionen`
--

CREATE TABLE `positionen` (
  `positionen_id` int(255) NOT NULL,
  `bestellungen_id` int(255) NOT NULL,
  `produkt_id` int(255) NOT NULL,
  `menge` int(255) NOT NULL,
  `preis` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Daten für Tabelle `positionen`
--

INSERT INTO `positionen` (`positionen_id`, `bestellungen_id`, `produkt_id`, `menge`, `preis`) VALUES
(1, 1, 2, 2, 70.00),
(2, 2, 30, 9, 3871.00),
(3, 2, 22, 9, 1950.00),
(4, 2, 27, 5, 2343.00),
(5, 2, 1, 5, 2500.00),
(6, 2, 1, 10, 5000.00),
(7, 3, 23, 7, 1146.00),
(8, 3, 16, 4, 26.00),
(9, 3, 17, 9, 2052.00),
(10, 3, 2, 10, 350.00),
(11, 3, 30, 7, 3011.00),
(12, 4, 12, 2, 346.00),
(13, 4, 7, 2, 463.00),
(14, 4, 22, 6, 1300.00),
(15, 4, 1, 4, 2000.00),
(16, 5, 15, 8, 3112.00),
(17, 5, 27, 9, 4218.00),
(18, 5, 19, 1, 18.00),
(19, 5, 16, 6, 39.00),
(20, 5, 4, 8, 1560.00),
(21, 6, 1, 3, 1500.00),
(22, 6, 5, 6, 837.00),
(23, 6, 24, 2, 872.00),
(24, 6, 13, 1, 134.00),
(25, 6, 17, 2, 456.00),
(26, 7, 25, 1, 168.00),
(27, 8, 21, 9, 3009.00),
(28, 8, 12, 4, 693.00),
(29, 8, 20, 9, 3743.00),
(30, 8, 7, 6, 1390.00),
(31, 8, 23, 3, 491.00),
(32, 9, 17, 1, 228.00),
(33, 9, 8, 9, 4180.00),
(34, 9, 7, 2, 463.00),
(35, 9, 1, 1, 500.00),
(36, 9, 24, 7, 3051.00),
(37, 10, 12, 9, 1558.00),
(38, 10, 26, 3, 479.00),
(39, 10, 13, 4, 537.00),
(40, 10, 1, 7, 3500.00),
(41, 11, 27, 4, 1874.00),
(42, 11, 5, 4, 558.00),
(43, 12, 18, 3, 141.00),
(44, 12, 27, 3, 1406.00),
(45, 12, 7, 7, 1621.00),
(46, 13, 29, 7, 1698.00),
(47, 13, 22, 1, 217.00),
(48, 13, 22, 8, 1734.00),
(49, 13, 19, 10, 181.00),
(50, 14, 9, 4, 697.00),
(51, 14, 26, 3, 479.00),
(52, 14, 27, 6, 2812.00),
(53, 14, 28, 7, 851.00),
(54, 15, 9, 3, 523.00),
(55, 15, 7, 10, 2316.00),
(56, 15, 1, 9, 4500.00),
(57, 15, 10, 9, 1432.00),
(58, 15, 16, 1, 7.00),
(59, 16, 15, 3, 1167.00),
(60, 17, 13, 4, 537.00),
(61, 17, 5, 5, 697.00),
(62, 17, 28, 1, 122.00),
(63, 17, 4, 5, 975.00),
(64, 18, 17, 8, 1824.00),
(65, 19, 22, 4, 867.00),
(66, 19, 18, 5, 235.00),
(67, 19, 4, 8, 1560.00),
(68, 19, 22, 3, 650.00),
(69, 19, 10, 10, 1591.00),
(70, 20, 7, 8, 1853.00),
(71, 20, 7, 3, 695.00),
(72, 20, 28, 1, 122.00),
(73, 20, 27, 10, 4686.00),
(74, 21, 12, 7, 1212.00),
(75, 21, 20, 8, 3327.00),
(76, 21, 26, 4, 639.00),
(77, 22, 16, 4, 26.00),
(78, 23, 20, 4, 1663.00),
(79, 23, 20, 3, 1248.00),
(80, 23, 19, 1, 18.00),
(81, 23, 6, 9, 4146.00),
(82, 24, 18, 8, 375.00),
(83, 24, 10, 3, 477.00),
(84, 24, 2, 7, 245.00),
(85, 25, 16, 6, 39.00),
(86, 25, 25, 10, 1678.00),
(87, 25, 15, 7, 2723.00),
(88, 25, 5, 1, 139.00),
(89, 26, 26, 3, 479.00),
(90, 26, 16, 4, 26.00),
(91, 26, 10, 10, 1591.00),
(92, 26, 25, 10, 1678.00),
(93, 26, 29, 3, 728.00),
(94, 27, 5, 2, 279.00),
(95, 27, 10, 5, 796.00),
(96, 27, 3, 2, 336.00),
(97, 27, 24, 9, 3922.00),
(98, 28, 6, 6, 2764.00),
(99, 28, 16, 7, 46.00),
(100, 28, 16, 1, 7.00),
(101, 28, 18, 6, 282.00),
(102, 29, 2, 10, 350.00),
(103, 30, 22, 1, 217.00),
(104, 31, 25, 2, 336.00),
(105, 31, 16, 7, 46.00),
(106, 32, 22, 8, 1734.00),
(107, 32, 23, 1, 164.00),
(108, 33, 13, 8, 1074.00),
(109, 33, 5, 8, 1116.00),
(110, 33, 27, 1, 469.00),
(111, 33, 8, 6, 2787.00),
(112, 34, 27, 2, 937.00),
(113, 35, 28, 4, 486.00),
(114, 36, 7, 2, 463.00),
(115, 36, 1, 4, 2000.00),
(116, 36, 1, 2, 1000.00),
(117, 36, 18, 5, 235.00),
(118, 36, 30, 3, 1290.00),
(119, 37, 5, 3, 418.00),
(120, 37, 7, 10, 2316.00),
(121, 38, 14, 7, 646.00),
(122, 38, 28, 4, 486.00),
(123, 38, 2, 2, 70.00),
(124, 39, 7, 1, 232.00),
(125, 39, 29, 6, 1455.00),
(126, 39, 13, 4, 537.00),
(127, 39, 18, 7, 328.00),
(128, 39, 9, 9, 1568.00),
(129, 40, 16, 1, 7.00),
(130, 41, 19, 2, 36.00),
(131, 41, 16, 2, 13.00),
(132, 41, 4, 6, 1170.00),
(133, 41, 26, 2, 319.00),
(134, 42, 13, 2, 268.00),
(135, 42, 12, 4, 693.00),
(136, 42, 2, 4, 140.00),
(137, 42, 4, 3, 585.00),
(138, 43, 28, 5, 608.00),
(139, 44, 4, 2, 390.00),
(140, 44, 11, 8, 3081.00),
(141, 44, 2, 10, 350.00),
(142, 44, 22, 6, 1300.00),
(143, 44, 23, 2, 327.00),
(144, 45, 12, 9, 1558.00),
(145, 45, 3, 7, 1177.00),
(146, 46, 3, 4, 673.00),
(147, 46, 16, 9, 59.00),
(148, 46, 4, 6, 1170.00),
(149, 47, 19, 8, 145.00),
(150, 47, 9, 8, 1393.00),
(151, 47, 23, 1, 164.00),
(152, 48, 13, 9, 1208.00),
(153, 48, 7, 6, 1390.00),
(154, 48, 8, 3, 1393.00),
(155, 48, 17, 9, 2052.00),
(156, 49, 8, 10, 4645.00),
(157, 49, 23, 3, 491.00),
(158, 49, 22, 3, 650.00),
(159, 50, 16, 5, 33.00),
(160, 50, 12, 2, 346.00),
(161, 50, 10, 2, 318.00),
(162, 50, 24, 3, 1307.00),
(163, 51, 3, 5, 841.00),
(164, 51, 8, 2, 929.00),
(165, 51, 1, 8, 4000.00),
(166, 51, 18, 4, 188.00),
(167, 51, 19, 9, 163.00),
(168, 52, 3, 1, 168.00),
(169, 52, 24, 2, 872.00),
(170, 52, 4, 7, 1365.00),
(171, 53, 4, 6, 1170.00),
(172, 53, 22, 1, 217.00),
(173, 54, 23, 2, 327.00),
(174, 54, 5, 6, 837.00),
(175, 54, 28, 8, 973.00),
(176, 55, 1, 1, 500.00),
(177, 55, 28, 10, 1216.00),
(178, 55, 18, 1, 47.00),
(179, 55, 12, 9, 1558.00),
(180, 55, 7, 10, 2316.00),
(181, 59, 91, 1, 89.99),
(182, 59, 1, 1, 500.00),
(183, 59, 6, 1, 460.69),
(184, 59, 107, 1, 89.00),
(185, 60, 11, 1, 385.13),
(186, 60, 5, 2, 278.92),
(187, 60, 106, 1, 99.00),
(188, 60, 92, 1, 45.00),
(189, 61, 94, 1, 69.99),
(190, 61, 98, 1, 59.99),
(191, 61, 7, 1, 231.63),
(192, 62, 95, 1, 129.00),
(193, 62, 14, 2, 184.70),
(194, 62, 101, 1, 49.99),
(195, 62, 69, 3, 59.97),
(196, 63, 110, 1, 139.00),
(197, 63, 75, 1, 199.00),
(198, 63, 79, 1, 79.90),
(199, 63, 80, 1, 159.00),
(200, 64, 103, 1, 199.00),
(201, 64, 82, 2, 358.00),
(202, 64, 70, 5, 64.95),
(203, 65, 99, 1, 79.99),
(204, 65, 13, 2, 268.46),
(205, 65, 85, 1, 249.00),
(206, 65, 21, 1, 334.35),
(207, 66, 91, 1, 89.99),
(208, 66, 68, 1, 299.00),
(209, 66, 27, 1, 468.62),
(210, 66, 23, 1, 163.69),
(211, 66, 25, 1, 167.77),
(212, 66, 100, 1, 119.00),
(213, 67, 108, 1, 179.00),
(214, 67, 30, 1, 430.11),
(215, 67, 15, 1, 389.06),
(216, 67, 12, 1, 173.15),
(217, 67, 20, 1, 415.87),
(218, 68, 115, 1, 39.99),
(219, 68, 117, 1, 35.00),
(220, 68, 98, 1, 59.99),
(221, 68, 113, 2, 59.98),
(222, 69, 1, 1, 500.00),
(223, 69, 6, 2, 921.38),
(224, 69, 65, 1, 89.95),
(225, 69, 89, 2, 658.00),
(226, 70, 104, 1, 249.00),
(227, 70, 109, 1, 69.99),
(228, 70, 118, 1, 149.00),
(229, 70, 119, 3, 179.97),
(230, 71, 81, 1, 249.00),
(231, 71, 82, 1, 179.00),
(232, 71, 84, 2, 79.80),
(233, 71, 76, 2, 69.98),
(234, 72, 64, 3, 329.97),
(235, 72, 7, 2, 463.26),
(236, 72, 71, 5, 89.95),
(237, 73, 63, 1, 219.00),
(238, 73, 73, 1, 44.90),
(239, 73, 67, 2, 79.98),
(240, 73, 74, 1, 29.99),
(241, 74, 80, 1, 159.00),
(242, 74, 66, 2, 119.80),
(243, 74, 28, 1, 121.59),
(244, 74, 77, 3, 44.97),
(245, 75, 117, 1, 35.00),
(246, 75, 118, 1, 149.00),
(247, 75, 109, 1, 69.99),
(248, 75, 94, 1, 69.99),
(249, 76, 111, 1, 79.99),
(250, 76, 88, 1, 99.00),
(251, 76, 78, 6, 135.00),
(252, 76, 87, 1, 12.50),
(253, 77, 120, 1, 199.00),
(254, 77, 96, 1, 39.99),
(255, 77, 93, 1, 149.00),
(256, 78, 68, 1, 299.00),
(257, 78, 23, 2, 327.38),
(258, 78, 26, 1, 159.67),
(259, 78, 112, 1, 99.99),
(260, 79, 2, 1, 35.00),
(261, 79, 3, 1, 168.19),
(262, 79, 10, 1, 159.13),
(263, 79, 92, 1, 45.00),
(264, 79, 97, 2, 59.98),
(265, 80, 102, 1, 35.00),
(266, 80, 20, 1, 415.87),
(267, 80, 24, 1, 435.79),
(268, 81, 61, 2, 49.98),
(269, 81, 72, 1, 129.00),
(270, 81, 83, 3, 65.97),
(271, 81, 16, 10, 65.20),
(272, 82, 28, 2, 243.18),
(273, 82, 66, 1, 59.90),
(274, 82, 79, 1, 79.90),
(275, 82, 9, 1, 174.17),
(276, 83, 116, 1, 25.00),
(277, 83, 114, 1, 49.99),
(278, 83, 115, 1, 39.99),
(279, 84, 27, 1, 468.62),
(280, 84, 68, 1, 299.00),
(281, 84, 91, 1, 89.99),
(282, 84, 100, 1, 119.00),
(283, 84, 111, 1, 79.99),
(284, 85, 60, 3, 89.70),
(285, 85, 62, 1, 49.90),
(286, 85, 90, 2, 59.80),
(287, 85, 70, 1, 12.99),
(288, 86, 65, 1, 89.95),
(289, 86, 75, 1, 199.00),
(290, 86, 89, 1, 329.00),
(291, 86, 110, 1, 139.00),
(292, 87, 95, 1, 129.00),
(293, 87, 14, 3, 277.05),
(294, 87, 21, 1, 334.35),
(295, 87, 85, 2, 498.00),
(296, 88, 8, 1, 464.46),
(297, 88, 74, 1, 29.99),
(298, 88, 84, 1, 39.90),
(299, 88, 108, 1, 179.00),
(300, 89, 2, 2, 70.00),
(301, 89, 16, 5, 32.60),
(302, 89, 19, 3, 54.33),
(303, 89, 18, 1, 46.92),
(304, 90, 21, 1, 334.35),
(305, 90, 85, 4, 996.00),
(306, 90, 95, 1, 129.00),
(307, 90, 104, 1, 249.00),
(308, 91, 96, 1, 39.99),
(309, 91, 7, 1, 231.63),
(310, 91, 23, 1, 163.69),
(311, 91, 113, 1, 29.99),
(312, 92, 11, 2, 770.26),
(313, 92, 5, 4, 557.84),
(314, 92, 20, 2, 831.74),
(315, 92, 95, 1, 129.00),
(316, 92, 106, 2, 198.00),
(317, 93, 88, 1, 99.00),
(318, 93, 79, 1, 79.90),
(319, 93, 3, 1, 168.19),
(320, 93, 18, 2, 93.84),
(321, 94, 93, 1, 149.00),
(322, 94, 99, 1, 79.99),
(323, 94, 13, 1, 134.23),
(324, 95, 75, 2, 398.00),
(325, 95, 110, 1, 139.00),
(326, 95, 97, 1, 29.99),
(327, 96, 112, 1, 99.99),
(328, 96, 98, 1, 59.99),
(329, 96, 100, 1, 119.00),
(330, 96, 115, 1, 39.99),
(331, 97, 114, 1, 49.99),
(332, 97, 87, 3, 37.50),
(333, 97, 86, 2, 33.98),
(334, 98, 89, 2, 658.00),
(335, 98, 72, 1, 129.00),
(336, 98, 67, 2, 79.98),
(337, 98, 77, 2, 29.98),
(338, 99, 116, 1, 25.00),
(339, 99, 102, 1, 35.00),
(340, 99, 97, 1, 29.99),
(341, 100, 119, 5, 299.95),
(342, 100, 118, 1, 149.00),
(343, 100, 120, 1, 199.00),
(344, 101, 64, 2, 219.98),
(345, 101, 85, 1, 249.00),
(346, 101, 99, 1, 79.99),
(347, 102, 1, 1, 500.00),
(348, 102, 6, 1, 460.69),
(349, 102, 79, 1, 79.90),
(350, 102, 91, 1, 89.99),
(351, 103, 62, 1, 49.90),
(352, 103, 60, 2, 59.80),
(353, 103, 90, 1, 29.90),
(354, 103, 70, 2, 25.98),
(355, 104, 1, 1, 500.00),
(356, 104, 27, 1, 468.62),
(357, 104, 89, 1, 329.00),
(358, 104, 65, 1, 89.95),
(359, 105, 109, 1, 69.99),
(360, 105, 117, 1, 35.00),
(361, 105, 118, 1, 149.00),
(362, 105, 14, 1, 92.35),
(363, 106, 98, 1, 59.99),
(364, 106, 115, 1, 39.99),
(365, 106, 113, 3, 89.97),
(366, 106, 94, 1, 69.99),
(367, 107, 110, 1, 139.00),
(368, 107, 75, 1, 199.00),
(369, 107, 80, 1, 159.00),
(370, 107, 28, 1, 121.59),
(371, 108, 91, 1, 89.99),
(372, 108, 68, 1, 299.00),
(373, 108, 27, 1, 468.62),
(374, 108, 23, 1, 163.69),
(375, 108, 64, 1, 109.99),
(376, 108, 92, 1, 45.00),
(377, 108, 97, 2, 59.98);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `produkte`
--

CREATE TABLE `produkte` (
  `produkte_id` int(255) NOT NULL,
  `artikel` varchar(255) NOT NULL,
  `preis` decimal(10,2) NOT NULL,
  `lagerbestand` int(255) NOT NULL,
  `kategorie_id` int(11) DEFAULT NULL,
  `mindestbestand` int(11) NOT NULL DEFAULT 5
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Daten für Tabelle `produkte`
--

INSERT INTO `produkte` (`produkte_id`, `artikel`, `preis`, `lagerbestand`, `kategorie_id`, `mindestbestand`) VALUES
(1, 'Computer', 398.00, 20, 2, 0),
(2, 'Tastatur', 35.00, 15, 1, 0),
(3, 'Gaming-Maus', 168.19, 27, 1, 0),
(4, 'Mechanische Tastatur', 195.01, 32, 1, 0),
(5, '27\" Monitor', 199.00, 10, 5, 0),
(6, 'Grafikkarte RTX 4070', 460.69, 71, 1, 0),
(7, 'SSD 2TB', 231.63, 53, 1, 0),
(8, 'Gaming-Notebook', 464.46, 110, 2, 0),
(9, 'Bluetooth-Headset', 174.17, 8, 5, 0),
(10, 'Webcam Full HD', 159.13, 133, 5, 0),
(11, 'Office-PC', 385.13, 96, 2, 0),
(12, 'USB-C Dockingstation', 173.15, 140, 5, 0),
(13, 'Externe Festplatte 4TB', 134.23, 69, 5, 0),
(14, 'WLAN-Router', 92.35, 116, 5, 0),
(15, 'Curved Monitor 34\"', 389.06, 84, 5, 0),
(16, 'USB-Stick 64GB', 6.52, 105, 5, 0),
(17, 'Mini-PC', 228.04, 32, 2, 0),
(18, 'Gaming-Mauspad', 46.92, 33, 5, 0),
(19, 'HDMI-Kabel', 18.11, 64, 5, 0),
(20, 'All-in-One Drucker', 415.87, 130, 2, 0),
(21, 'NAS-System', 334.35, 48, 2, 0),
(22, 'Mainboard ATX', 216.70, 94, 1, 0),
(23, 'RAM 32GB Kit', 163.69, 121, 1, 0),
(24, 'Laser-Drucker', 435.79, 65, 2, 0),
(25, 'PC-Gehäuse', 167.77, 113, 1, 0),
(26, 'Netzteil 750W', 159.67, 124, 1, 0),
(27, 'Grafikkarte RX 7900', 468.62, 147, 1, 0),
(28, 'Bluetooth-Lautsprecher', 121.59, 118, 5, 0),
(29, 'CPU Intel i7', 242.52, 126, 1, 0),
(30, 'Ultrabook', 430.11, 149, 2, 0),
(60, 'Wireless Charging Pad', 29.90, 100, 5, 0),
(61, 'USB-Hub 7-fach', 24.99, 80, 5, 0),
(62, 'Wireless Tastatur', 49.90, 75, 5, 0),
(63, 'Gaming-Stuhl', 219.00, 40, 5, 0),
(64, 'M.2 SSD 1TB', 109.99, 60, 1, 0),
(65, 'Grafiktablett', 89.95, 35, 5, 0),
(66, 'PC-Lautsprecher', 59.90, 90, 5, 0),
(67, 'Monitorhalterung', 39.99, 55, 5, 0),
(68, 'CPU AMD Ryzen 7', 299.00, 30, 1, 0),
(69, 'WLAN-Adapter USB', 19.99, 120, 5, 0),
(70, 'Bluetooth-Adapter', 12.99, 110, 5, 0),
(71, 'MicroSD-Karte 128GB', 17.99, 200, 5, 0),
(72, 'Dockingstation Dual Monitor', 129.00, 25, 5, 0),
(73, 'Ergonomische Maus', 44.90, 70, 5, 0),
(74, 'Notebook-Kühler', 29.99, 65, 5, 0),
(75, 'Webcam 4K', 199.00, 20, 5, 0),
(76, 'USB-C Ladegerät', 34.99, 85, 5, 0),
(77, 'DisplayPort-Kabel', 14.99, 100, 5, 0),
(78, 'PC-Lüfter RGB', 22.50, 150, 1, 0),
(79, 'Gaming-Headset', 79.90, 60, 5, 0),
(80, 'Mini-Beamer', 159.00, 18, 2, 0),
(81, 'Tablet 10\"', 249.00, 45, 2, 0),
(82, 'Smartwatch', 179.00, 38, 2, 0),
(83, 'USB-C auf HDMI Adapter', 21.99, 95, 5, 0),
(84, 'Powerbank 20000mAh', 31.99, 70, 5, 0),
(85, 'NAS Festplatte 8TB', 249.00, 22, 1, 0),
(86, 'Grafikkartenhalter', 16.99, 80, 5, 0),
(87, 'Kabelmanagement-Set', 12.50, 140, 5, 0),
(88, 'Gaming-Tastatur RGB', 99.00, 50, 5, 0),
(89, 'USB-C Monitor 27\"', 329.00, 28, 5, 0),
(90, 'Wireless Charging Pad', 29.90, 100, 5, 0),
(91, 'PC-Zusammenbau Service', 89.99, 999, 4, 0),
(92, 'Windows Installation', 45.00, 999, 4, 0),
(93, 'Datenrettung Festplatte', 199.00, 999, 4, 0),
(94, 'Virus-Entfernung', 69.99, 999, 4, 0),
(95, 'Netzwerk-Einrichtung', 129.00, 999, 4, 0),
(96, 'Hardware-Diagnose', 39.99, 999, 4, 0),
(97, 'Software-Installation', 29.99, 999, 4, 0),
(98, 'System-Optimierung', 59.99, 999, 4, 0),
(99, 'Backup-Einrichtung', 79.99, 999, 4, 0),
(100, 'Gaming-PC Tuning', 119.00, 999, 4, 0),
(101, 'WLAN-Optimierung', 49.99, 999, 4, 0),
(102, 'Drucker-Installation', 35.00, 999, 4, 0),
(103, 'Smart Home Einrichtung', 199.00, 999, 4, 0),
(104, 'Cloud-Migration', 249.00, 999, 4, 0),
(105, 'IT-Schulung Grundlagen', 159.00, 999, 4, 0),
(106, 'Office-Software Training', 99.00, 999, 4, 0),
(107, 'Gaming-Setup Beratung', 89.00, 999, 4, 0),
(108, 'Homeoffice-Einrichtung', 179.00, 999, 4, 0),
(109, 'VPN-Konfiguration', 69.99, 999, 4, 0),
(110, 'Streaming-Setup', 139.00, 999, 4, 0),
(111, 'RGB-Beleuchtung Setup', 79.99, 999, 4, 0),
(112, 'Overclock-Service', 99.99, 999, 4, 0),
(113, 'Firmware-Update', 29.99, 999, 4, 0),
(114, 'Kabel-Management', 49.99, 999, 4, 0),
(115, 'Performance-Check', 39.99, 999, 4, 0),
(116, 'E-Mail-Einrichtung', 25.00, 999, 4, 0),
(117, 'Antivirus-Installation', 35.00, 999, 4, 0),
(118, 'Datenschutz-Beratung', 149.00, 999, 4, 0),
(119, 'Remote-Support 1h', 59.99, 999, 4, 0),
(120, 'Express-Reparatur', 199.00, 999, 4, 0),
(121, 'WEBCAM', 9.99, 12, 3, 5),
(122, 'USB KABEL 2M', 9.99, 1, NULL, 5),
(123, 'USB LAUTSPRECHER', 9.99, 10, 4, 5),
(124, 'SUPER MAUS', 9.99, 5, NULL, 10),
(125, 'DRUCKERTINTE', 14.99, 10, 1, 5);

--
-- Trigger `produkte`
--
DELIMITER $$
CREATE TRIGGER `korrigiere_neue_produkte` BEFORE INSERT ON `produkte` FOR EACH ROW BEGIN
-- Automatische Korrekturen vor dem Speichern
IF NEW.preis <= 0 THEN
SET NEW.preis = 9.99; -- Mindestpreis
END IF;
IF NEW.mindestbestand IS NULL THEN
SET NEW.mindestbestand = 0; -- Standardbestand
END IF;
-- Artikel-Name groß schreiben
SET NEW.artikel = UPPER(NEW.artikel);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `korrigiere_upgedatete_produkte` AFTER UPDATE ON `produkte` FOR EACH ROW BEGIN
-- Automatische Korrekturen vor dem Speichern
	

Insert into log_table(produkte_id,oldprice,newprice,jetzt) values(OLD.produkte_id,OLD.preis,NEW.preis,NOW());

END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Stellvertreter-Struktur des Views `Zufallszahl`
-- (Siehe unten für die tatsächliche Ansicht)
--
CREATE TABLE `Zufallszahl` (
`Floor(rand()*6 +1)` double(17,0)
);

-- --------------------------------------------------------

--
-- Struktur des Views `Haeufigkeit`
--
DROP TABLE IF EXISTS `Haeufigkeit`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `Haeufigkeit`  AS SELECT `p`.`artikel` AS `Produktname`, count(`pos`.`produkt_id`) AS `Bestellhaeufigkeit`, `p`.`preis` AS `preis` FROM (`produkte` `p` left join `positionen` `pos` on(`p`.`produkte_id` = `pos`.`produkt_id`)) GROUP BY `p`.`artikel`, `p`.`preis` ORDER BY count(`pos`.`produkt_id`) DESC ;

-- --------------------------------------------------------

--
-- Struktur des Views `Häufigkeit`
--
DROP TABLE IF EXISTS `Häufigkeit`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `Häufigkeit`  AS SELECT `p`.`artikel` AS `Produktname`, count(`pos`.`produkt_id`) AS `Bestellhaeufigkeit`, `p`.`preis` AS `preis` FROM (`produkte` `p` left join `positionen` `pos` on(`p`.`produkte_id` = `pos`.`produkt_id`)) GROUP BY `p`.`artikel`, `p`.`preis` ORDER BY count(`pos`.`produkt_id`) DESC ;

-- --------------------------------------------------------

--
-- Struktur des Views `Zufallszahl`
--
DROP TABLE IF EXISTS `Zufallszahl`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `Zufallszahl`  AS SELECT floor(rand() * 6 + 1) AS `Floor(rand()*6 +1)` ;

--
-- Indizes der exportierten Tabellen
--

--
-- Indizes für die Tabelle `bestellungen`
--
ALTER TABLE `bestellungen`
  ADD PRIMARY KEY (`bestellungen_id`),
  ADD KEY `fk_bestellungen_kunden` (`kunden_id`);

--
-- Indizes für die Tabelle `event_logs`
--
ALTER TABLE `event_logs`
  ADD PRIMARY KEY (`log_id`),
  ADD KEY `idx_event_name` (`event_name`),
  ADD KEY `idx_ausführung_zeit` (`ausführung_zeit`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_event_zeit` (`event_name`,`ausführung_zeit`),
  ADD KEY `idx_ausführung_id` (`ausführung_id`);

--
-- Indizes für die Tabelle `kategorien`
--
ALTER TABLE `kategorien`
  ADD PRIMARY KEY (`kategorie_id`);

--
-- Indizes für die Tabelle `kunden`
--
ALTER TABLE `kunden`
  ADD PRIMARY KEY (`kunden_id`);

--
-- Indizes für die Tabelle `kunden_welcome_log`
--
ALTER TABLE `kunden_welcome_log`
  ADD PRIMARY KEY (`kw_id`);

--
-- Indizes für die Tabelle `lieferungen`
--
ALTER TABLE `lieferungen`
  ADD PRIMARY KEY (`lieferungen_id`),
  ADD KEY `fk_lieferungen_bestellungen` (`bestellungen_id`);

--
-- Indizes für die Tabelle `log_table`
--
ALTER TABLE `log_table`
  ADD PRIMARY KEY (`counter`);

--
-- Indizes für die Tabelle `positionen`
--
ALTER TABLE `positionen`
  ADD PRIMARY KEY (`positionen_id`),
  ADD KEY `fk_positionen_bestellungen` (`bestellungen_id`),
  ADD KEY `fk_positionen_produkte` (`produkt_id`);

--
-- Indizes für die Tabelle `produkte`
--
ALTER TABLE `produkte`
  ADD PRIMARY KEY (`produkte_id`),
  ADD KEY `fk_produkte_kategorien` (`kategorie_id`);

--
-- AUTO_INCREMENT für exportierte Tabellen
--

--
-- AUTO_INCREMENT für Tabelle `bestellungen`
--
ALTER TABLE `bestellungen`
  MODIFY `bestellungen_id` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=109;

--
-- AUTO_INCREMENT für Tabelle `event_logs`
--
ALTER TABLE `event_logs`
  MODIFY `log_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT für Tabelle `kategorien`
--
ALTER TABLE `kategorien`
  MODIFY `kategorie_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT für Tabelle `kunden`
--
ALTER TABLE `kunden`
  MODIFY `kunden_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=255;

--
-- AUTO_INCREMENT für Tabelle `kunden_welcome_log`
--
ALTER TABLE `kunden_welcome_log`
  MODIFY `kw_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT für Tabelle `lieferungen`
--
ALTER TABLE `lieferungen`
  MODIFY `lieferungen_id` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=106;

--
-- AUTO_INCREMENT für Tabelle `log_table`
--
ALTER TABLE `log_table`
  MODIFY `counter` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT für Tabelle `positionen`
--
ALTER TABLE `positionen`
  MODIFY `positionen_id` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=378;

--
-- AUTO_INCREMENT für Tabelle `produkte`
--
ALTER TABLE `produkte`
  MODIFY `produkte_id` int(255) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=126;

--
-- Constraints der exportierten Tabellen
--

--
-- Constraints der Tabelle `bestellungen`
--
ALTER TABLE `bestellungen`
  ADD CONSTRAINT `fk_bestellungen_kunden` FOREIGN KEY (`kunden_id`) REFERENCES `kunden` (`kunden_id`) ON UPDATE CASCADE;

--
-- Constraints der Tabelle `lieferungen`
--
ALTER TABLE `lieferungen`
  ADD CONSTRAINT `fk_lieferungen_bestellungen` FOREIGN KEY (`bestellungen_id`) REFERENCES `bestellungen` (`bestellungen_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints der Tabelle `positionen`
--
ALTER TABLE `positionen`
  ADD CONSTRAINT `fk_positionen_bestellungen` FOREIGN KEY (`bestellungen_id`) REFERENCES `bestellungen` (`bestellungen_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_positionen_produkte` FOREIGN KEY (`produkt_id`) REFERENCES `produkte` (`produkte_id`) ON UPDATE CASCADE;

--
-- Constraints der Tabelle `produkte`
--
ALTER TABLE `produkte`
  ADD CONSTRAINT `fk_produkte_kategorien` FOREIGN KEY (`kategorie_id`) REFERENCES `kategorien` (`kategorie_id`) ON DELETE SET NULL ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
