package com.ibb.ctrl;

import com.ibb.util.GConnection;
import com.ibb.model.Customer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
////import jakarta.naming.InitialContext;
////import jakarta.naming.NamingException;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
//import jakarta.sql.DataSource;


@WebServlet("/signin")
public class SigninServlet extends GConnection {
	private static final long serialVersionUID = 1L;

	protected void doPost(
		HttpServletRequest request, 
		HttpServletResponse response) 
				throws ServletException, IOException {
		String email = request.getParameter("email");
		String password = request.getParameter("password");
				
		try {
                   // request.login(email, password);
                    //if(request.isUserInRole(email))
			Customer customer = find(email, password);
			
			if(customer!=null) {
				HttpSession session = request.getSession();
				session.setAttribute("customer", customer);
			}
		} catch (Exception e) {
			throw new ServletException(e.getMessage());
		}
		response.setContentType(
				"text/html;charset=UTF-8");
		
		RequestDispatcher rd = request.getRequestDispatcher("index.jsp");
		rd.forward(request, response);
	}
	
	public Customer find(
			String _email, 
			String _password) {
            try {
               
                Connection con=getConnection();
               
                PreparedStatement stmt = con.prepareStatement("SELECT id, email, password FROM customer WHERE email=? AND password=?");
                
                stmt.setString(1, _email);
                stmt.setString(2, getPassword(_password));
                
                ResultSet rs = stmt.executeQuery();
                if(rs.next()) {
                    System.out.println("Gibt es einen Treffer");
                    Customer customer = new Customer();
                    
                    Long id = Long.valueOf(rs.getLong("id"));
                    customer.setId(id);
                    
                    String email = rs.getString("email");
                    customer.setEmail(email);
                    
                    String password = rs.getString("password");
                    customer.setPassword(password);
                    
                    return customer;
                }
                con.close();
                return null;
//            } catch (NamingException ex) {
//                Logger.getLogger(SigninServlet.class.getName()).log(Level.SEVERE, null, ex);
            } catch (SQLException ex) {
                Logger.getLogger(SigninServlet.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
	}
        
         public  String getPassword(String password) {

        StringBuffer result = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");

            byte[] hash = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            result = new StringBuffer();
            for (byte byt : hash) {
                result.append(Integer.toString((byt & 0xff) + 0x100, 16).substring(1));
            }

        } catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(SigninServlet.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result.toString();
    }

}
