<%@ page import="com.ibb.model.Customer" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Java Fleet AuthDemo</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: #f5f5f5;
            min-height: 100vh;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 24px;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .logout-btn {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 8px 20px;
            border-radius: 5px;
            text-decoration: none;
            transition: background 0.3s;
        }
        
        .logout-btn:hover {
            background: rgba(255,255,255,0.3);
        }
        
        .container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 0 20px;
        }
        
        .welcome-card {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            text-align: center;
        }
        
        .welcome-card h2 {
            color: #333;
            margin-bottom: 20px;
            font-size: 32px;
        }
        
        .welcome-card p {
            color: #666;
            font-size: 16px;
            line-height: 1.6;
        }
        
        .success-icon {
            font-size: 60px;
            margin-bottom: 20px;
        }
        
        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-top: 40px;
        }
        
        .feature-card {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            text-align: center;
        }
        
        .feature-icon {
            font-size: 40px;
            margin-bottom: 15px;
        }
        
        .feature-card h3 {
            color: #333;
            margin-bottom: 10px;
        }
        
        .feature-card p {
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <%
        Customer customer = (Customer) session.getAttribute("customer");
        
        if(customer == null) {
            // Nicht eingeloggt → Redirect zu Login
            response.sendRedirect("signin.jsp");
            return;
        }
    %>
    
    <div class="header">
        <div class="header-content">
            <h1>🚀 Java Fleet AuthDemo</h1>
            <div class="user-info">
                <span>Hallo, <%= customer.getEmail() %>!</span>
                <a href="signout.jsp" class="logout-btn">Abmelden</a>
            </div>
        </div>
    </div>
    
    <div class="container">
        <div class="welcome-card">
            <div class="success-icon">✅</div>
            <h2>Login erfolgreich!</h2>
            <p>
                Du bist jetzt eingeloggt im Java Fleet AuthDemo.<br>
                Dies ist ein Demo-Projekt für Tag 3 des Java Web Aufbau Kurses.
            </p>
        </div>
        
        <div class="features">
            <div class="feature-card">
                <div class="feature-icon">🔐</div>
                <h3>Sicheres Login</h3>
                <p>Passwörter werden mit SHA-256 gehasht und nie im Klartext gespeichert.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">🛡️</div>
                <h3>SQL-Injection-Schutz</h3>
                <p>Prepared Statements verhindern SQL-Injection-Angriffe effektiv.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">🍪</div>
                <h3>Session-Management</h3>
                <p>Sessions speichern den Login-Status sicher auf dem Server.</p>
            </div>
        </div>
    </div>
</body>
</html>
