package com.javafleet.security.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;

import java.io.IOException;
import java.util.logging.Logger;

/**
 * Logout Servlet - Beendet die Benutzersitzung
 * 
 * Implementiert korrektes Logout für Form-based Authentication:
 * 1. Session invalidieren
 * 2. request.logout() aufrufen (Container-Abmeldung)
 * 3. Redirect zur Startseite
 * 
 * HINWEIS: Bei Basic Authentication funktioniert Logout NICHT richtig,
 * da der Browser die Credentials cached!
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
@WebServlet(name = "LogoutServlet", urlPatterns = {"/logout"})
public class LogoutServlet extends HttpServlet {
    
    private static final Logger LOGGER = Logger.getLogger(LogoutServlet.class.getName());
    
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) 
            throws ServletException, IOException {
        
        String username = "anonymous";
        
        // 1. Username für Logging ermitteln (vor Session-Invalidierung!)
        if (request.getUserPrincipal() != null) {
            username = request.getUserPrincipal().getName();
        }
        
        // 2. Session invalidieren
        HttpSession session = request.getSession(false);
        if (session != null) {
            LOGGER.info("Invalidating session for user: " + username);
            session.invalidate();
        }
        
        // 3. Container-Logout durchführen
        try {
            request.logout();
            LOGGER.info("User logged out successfully: " + username);
        } catch (ServletException e) {
            LOGGER.warning("Error during logout: " + e.getMessage());
        }
        
        // 4. Redirect zur Startseite mit Logout-Bestätigung
        response.sendRedirect(request.getContextPath() + "/logout-success.jsp");
    }
    
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) 
            throws ServletException, IOException {
        // POST auch erlauben (für Formulare)
        doGet(request, response);
    }
}
