package com.javafleet.security.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;

/**
 * Öffentliches Servlet - Kein Login erforderlich
 * 
 * Dieses Servlet demonstriert einen ungeschützten Bereich,
 * der für alle Besucher zugänglich ist.
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
@WebServlet(name = "PublicServlet", urlPatterns = {"/public"})
public class PublicServlet extends HttpServlet {
    
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) 
            throws ServletException, IOException {
        
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        
        // Prüfen ob User eingeloggt ist (optional)
        String username = null;
        if (request.getUserPrincipal() != null) {
            username = request.getUserPrincipal().getName();
        }
        
        out.println("<!DOCTYPE html>");
        out.println("<html lang='de'>");
        out.println("<head>");
        out.println("  <meta charset='UTF-8'>");
        out.println("  <title>🌍 Öffentlicher Bereich</title>");
        out.println("  <style>");
        out.println("    body { font-family: 'Segoe UI', sans-serif; background: #1a1a2e; color: #E8E8E8; padding: 40px; }");
        out.println("    .container { max-width: 700px; margin: 0 auto; background: rgba(42,42,74,0.9); padding: 40px; border-radius: 16px; }");
        out.println("    h1 { color: #66BB6A; margin-bottom: 20px; }");
        out.println("    .info-box { background: rgba(102,187,106,0.1); border: 1px solid rgba(102,187,106,0.3); padding: 20px; border-radius: 10px; margin: 20px 0; }");
        out.println("    .info-box h3 { color: #66BB6A; margin-bottom: 10px; }");
        out.println("    .user-status { background: rgba(66,165,245,0.1); border: 1px solid rgba(66,165,245,0.3); padding: 15px; border-radius: 8px; margin-top: 20px; }");
        out.println("    a { color: #42A5F5; text-decoration: none; }");
        out.println("    a:hover { text-decoration: underline; }");
        out.println("    .btn { display: inline-block; padding: 12px 24px; background: linear-gradient(135deg, #42A5F5, #1E88E5); color: white; border-radius: 8px; margin-top: 20px; }");
        out.println("  </style>");
        out.println("</head>");
        out.println("<body>");
        out.println("  <div class='container'>");
        out.println("    <h1>🌍 Öffentlicher Bereich</h1>");
        out.println("    <p>Willkommen! Dieser Bereich ist <strong>ohne Login</strong> zugänglich.</p>");
        
        out.println("    <div class='info-box'>");
        out.println("      <h3>✓ Keine Security-Constraint</h3>");
        out.println("      <p>Dieses Servlet ist nicht durch <code>security-constraint</code> in der web.xml geschützt.</p>");
        out.println("      <p>Jeder kann darauf zugreifen – egal ob eingeloggt oder nicht.</p>");
        out.println("    </div>");
        
        out.println("    <div class='user-status'>");
        if (username != null) {
            out.println("      <p>👤 Du bist eingeloggt als: <strong>" + username + "</strong></p>");
            out.println("      <p><a href='" + request.getContextPath() + "/secure/user/dashboard'>→ Zum User-Dashboard</a></p>");
        } else {
            out.println("      <p>👻 Du bist aktuell <strong>nicht eingeloggt</strong>.</p>");
            out.println("      <p><a href='" + request.getContextPath() + "/login.jsp'>→ Jetzt anmelden</a></p>");
        }
        out.println("    </div>");
        
        out.println("    <a href='" + request.getContextPath() + "/' class='btn'>← Zurück zur Startseite</a>");
        out.println("  </div>");
        out.println("</body>");
        out.println("</html>");
    }
}
