<%@ page contentType="text/html;charset=UTF-8" language="java" isErrorPage="true" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🚫 403 - Zugriff verweigert</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .error-container {
            background: rgba(42, 42, 74, 0.95);
            padding: 50px;
            border-radius: 20px;
            text-align: center;
            max-width: 500px;
            border: 1px solid rgba(239, 83, 80, 0.5);
        }
        .error-code { font-size: 100px; font-weight: bold; color: #EF5350; margin-bottom: 10px; }
        h1 { color: #EF5350; font-size: 24px; margin-bottom: 20px; }
        p { color: #9E9E9E; font-size: 16px; margin-bottom: 20px; line-height: 1.6; }
        .info-box {
            background: rgba(255, 167, 38, 0.1);
            border: 1px solid rgba(255, 167, 38, 0.3);
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 30px;
            text-align: left;
        }
        .info-box h3 { color: #FFA726; font-size: 14px; margin-bottom: 10px; }
        .info-box ul { color: #E8E8E8; font-size: 14px; padding-left: 20px; }
        .info-box li { margin: 8px 0; }
        .actions { display: flex; gap: 15px; justify-content: center; flex-wrap: wrap; }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn-primary { background: linear-gradient(135deg, #42A5F5, #1E88E5); color: white; }
        .btn-secondary { background: rgba(158, 158, 158, 0.3); color: #E8E8E8; }
        .btn:hover { transform: translateY(-2px); }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-code">403</div>
        <h1>🚫 Zugriff verweigert!</h1>
        <p>
            Du hast nicht die erforderlichen Berechtigungen, um auf diese Ressource zuzugreifen.
        </p>
        
        <div class="info-box">
            <h3>💡 Was ist passiert?</h3>
            <ul>
                <li>Du bist eingeloggt, aber deine Rolle reicht nicht aus</li>
                <li>Diese Seite erfordert möglicherweise Admin-Rechte</li>
                <li>Frag einen Administrator, ob dir Zugriff gewährt werden kann</li>
            </ul>
        </div>
        
        <div class="actions">
            <a href="${pageContext.request.contextPath}/" class="btn btn-secondary">← Startseite</a>
            <a href="${pageContext.request.contextPath}/login.jsp" class="btn btn-primary">🔑 Neu anmelden</a>
        </div>
    </div>
</body>
</html>
