<%@ page contentType="text/html;charset=UTF-8" language="java" isErrorPage="true" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔍 404 - Seite nicht gefunden</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .error-container {
            background: rgba(42, 42, 74, 0.95);
            padding: 50px;
            border-radius: 20px;
            text-align: center;
            max-width: 500px;
            border: 1px solid rgba(66, 165, 245, 0.3);
        }
        .error-code { font-size: 100px; font-weight: bold; color: #42A5F5; margin-bottom: 10px; }
        h1 { color: #42A5F5; font-size: 24px; margin-bottom: 20px; }
        p { color: #9E9E9E; font-size: 16px; margin-bottom: 30px; line-height: 1.6; }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(135deg, #42A5F5, #1E88E5);
            color: white;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn:hover { transform: translateY(-2px); box-shadow: 0 10px 25px rgba(66, 165, 245, 0.4); }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-code">404</div>
        <h1>🔍 Seite nicht gefunden</h1>
        <p>
            Die angeforderte Seite existiert nicht oder wurde verschoben.
            Vielleicht hast du dich vertippt?
        </p>
        <a href="${pageContext.request.contextPath}/" class="btn">← Zurück zur Startseite</a>
    </div>
</body>
</html>
