<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🏠 Container-Managed Security Demo</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
            min-height: 100vh;
            color: #E8E8E8;
            padding: 40px 20px;
        }
        
        .container {
            max-width: 900px;
            margin: 0 auto;
        }
        
        header {
            text-align: center;
            margin-bottom: 50px;
        }
        
        header h1 {
            font-size: 36px;
            margin-bottom: 15px;
            background: linear-gradient(135deg, #42A5F5, #66BB6A);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        header p {
            color: #9E9E9E;
            font-size: 18px;
        }
        
        .badge-container {
            margin-top: 15px;
        }
        
        .badge {
            display: inline-block;
            padding: 6px 16px;
            border-radius: 20px;
            font-size: 12px;
            margin: 5px;
        }
        
        .badge-blue { background: linear-gradient(135deg, #42A5F5, #1E88E5); }
        .badge-green { background: linear-gradient(135deg, #66BB6A, #43A047); }
        .badge-orange { background: linear-gradient(135deg, #FFA726, #F57C00); color: #1a1a2e; }
        
        .areas-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 25px;
            margin-bottom: 50px;
        }
        
        .area-card {
            background: rgba(42, 42, 74, 0.9);
            border-radius: 16px;
            padding: 30px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }
        
        .area-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
        }
        
        .area-card.public { border-color: rgba(102, 187, 106, 0.5); }
        .area-card.user { border-color: rgba(66, 165, 245, 0.5); }
        .area-card.admin { border-color: rgba(255, 167, 38, 0.5); }
        
        .area-card h3 {
            font-size: 20px;
            margin-bottom: 10px;
        }
        
        .area-card.public h3 { color: #66BB6A; }
        .area-card.user h3 { color: #42A5F5; }
        .area-card.admin h3 { color: #FFA726; }
        
        .area-card p {
            color: #9E9E9E;
            font-size: 14px;
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .area-card .roles {
            font-size: 12px;
            color: #666;
            margin-bottom: 15px;
        }
        
        .area-card a {
            display: inline-block;
            padding: 12px 24px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s ease;
        }
        
        .area-card.public a {
            background: linear-gradient(135deg, #66BB6A, #43A047);
            color: white;
        }
        
        .area-card.user a {
            background: linear-gradient(135deg, #42A5F5, #1E88E5);
            color: white;
        }
        
        .area-card.admin a {
            background: linear-gradient(135deg, #FFA726, #F57C00);
            color: #1a1a2e;
        }
        
        .area-card a:hover {
            transform: scale(1.05);
        }
        
        .info-section {
            background: rgba(42, 42, 74, 0.7);
            border-radius: 16px;
            padding: 30px;
            margin-bottom: 30px;
        }
        
        .info-section h2 {
            color: #42A5F5;
            font-size: 22px;
            margin-bottom: 20px;
        }
        
        .info-section ul {
            list-style: none;
        }
        
        .info-section li {
            padding: 10px 0;
            padding-left: 30px;
            position: relative;
            color: #E8E8E8;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .info-section li:last-child {
            border-bottom: none;
        }
        
        .info-section li::before {
            content: "✓";
            color: #66BB6A;
            position: absolute;
            left: 5px;
            font-weight: bold;
        }
        
        footer {
            text-align: center;
            padding-top: 30px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            color: #666;
            font-size: 14px;
        }
        
        footer a {
            color: #42A5F5;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <h1>🛡️ Container-Managed Security Demo</h1>
            <p>Java Web Aufbau – Tag 4 von 10</p>
            <div class="badge-container">
                <span class="badge badge-blue">JDBC Realm</span>
                <span class="badge badge-green">Form-based Auth</span>
                <span class="badge badge-orange">Jakarta EE 10</span>
            </div>
        </header>
        
        <div class="areas-grid">
            <!-- Öffentlicher Bereich -->
            <div class="area-card public">
                <h3>🌍 Öffentlicher Bereich</h3>
                <p>
                    Dieser Bereich ist für alle Besucher zugänglich – 
                    kein Login erforderlich.
                </p>
                <div class="roles">Zugriff: Alle</div>
                <a href="${pageContext.request.contextPath}/public">Besuchen →</a>
            </div>
            
            <!-- User-Bereich -->
            <div class="area-card user">
                <h3>👤 User-Dashboard</h3>
                <p>
                    Geschützter Bereich für angemeldete Benutzer.
                    Erfordert Rolle "user" oder "admin".
                </p>
                <div class="roles">Zugriff: user, admin</div>
                <a href="${pageContext.request.contextPath}/secure/user/dashboard">Login erforderlich →</a>
            </div>
            
            <!-- Admin-Bereich -->
            <div class="area-card admin">
                <h3>⚙️ Admin-Panel</h3>
                <p>
                    Administrationsbereich mit erweiterten Rechten.
                    Nur für Administratoren zugänglich.
                </p>
                <div class="roles">Zugriff: nur admin</div>
                <a href="${pageContext.request.contextPath}/secure/admin/panel">Admin Login →</a>
            </div>
        </div>
        
        <div class="info-section">
            <h2>🎯 Was diese Demo zeigt:</h2>
            <ul>
                <li>Form-based Authentication mit j_security_check</li>
                <li>JDBC Realm mit MySQL Datenbank</li>
                <li>Rollen-basierte Zugriffskontrolle (admin, user)</li>
                <li>SHA-256 Passwort-Hashing</li>
                <li>Security Constraints in web.xml</li>
                <li>Konfiguration für Tomcat, GlassFish und Payara</li>
            </ul>
        </div>
        
        <footer>
            <p>
                © 2025 Java Fleet Systems Consulting | 
                <a href="https://www.java-developer.online" target="_blank">java-developer.online</a>
            </p>
        </footer>
    </div>
</body>
</html>
