<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>❌ Login fehlgeschlagen - Container Security Demo</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .error-container {
            background: rgba(42, 42, 74, 0.95);
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.5);
            max-width: 420px;
            width: 100%;
            border: 1px solid rgba(239, 83, 80, 0.5);
            text-align: center;
        }
        
        .error-icon {
            font-size: 60px;
            margin-bottom: 20px;
        }
        
        h1 {
            color: #EF5350;
            font-size: 24px;
            margin-bottom: 15px;
        }
        
        .error-message {
            color: #E8E8E8;
            font-size: 16px;
            margin-bottom: 25px;
            line-height: 1.6;
        }
        
        .error-details {
            background: rgba(239, 83, 80, 0.1);
            border: 1px solid rgba(239, 83, 80, 0.3);
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 25px;
        }
        
        .error-details h3 {
            color: #FFA726;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        .error-details ul {
            list-style: none;
            text-align: left;
        }
        
        .error-details li {
            color: #9E9E9E;
            font-size: 13px;
            padding: 5px 0;
            padding-left: 20px;
            position: relative;
        }
        
        .error-details li::before {
            content: "•";
            color: #EF5350;
            position: absolute;
            left: 5px;
        }
        
        .btn-retry {
            display: inline-block;
            padding: 14px 30px;
            background: linear-gradient(135deg, #42A5F5, #1E88E5);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .btn-retry:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(66, 165, 245, 0.4);
        }
        
        .demo-hint {
            margin-top: 20px;
            padding: 15px;
            background: rgba(102, 187, 106, 0.1);
            border: 1px solid rgba(102, 187, 106, 0.3);
            border-radius: 10px;
        }
        
        .demo-hint p {
            color: #66BB6A;
            font-size: 13px;
            font-family: 'Consolas', monospace;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-icon">🚫</div>
        <h1>Login fehlgeschlagen!</h1>
        
        <p class="error-message">
            Die eingegebenen Zugangsdaten sind ungültig oder du hast keine Berechtigung.
        </p>
        
        <div class="error-details">
            <h3>⚠️ Mögliche Ursachen:</h3>
            <ul>
                <li>Falscher Benutzername oder Passwort</li>
                <li>Benutzer existiert nicht in der Datenbank</li>
                <li>Passwort-Hash stimmt nicht überein</li>
                <li>JDBC Realm nicht korrekt konfiguriert</li>
            </ul>
        </div>
        
        <a href="${pageContext.request.contextPath}/login.jsp" class="btn-retry">
            🔄 Erneut versuchen
        </a>
        
        <div class="demo-hint">
            <p>💡 Demo: admin/admin123 oder john/john123</p>
        </div>
    </div>
</body>
</html>
