<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔒 Secure Login - Container Security Demo</title>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/css/style.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: rgba(42, 42, 74, 0.95);
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.5);
            max-width: 420px;
            width: 100%;
            border: 1px solid rgba(66, 165, 245, 0.3);
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .login-header h1 {
            color: #E8E8E8;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .login-header p {
            color: #9E9E9E;
            font-size: 14px;
        }
        
        .badge {
            display: inline-block;
            background: linear-gradient(135deg, #42A5F5, #1E88E5);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            margin-top: 10px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            color: #42A5F5;
            margin-bottom: 8px;
            font-weight: 600;
            font-size: 14px;
        }
        
        .form-group input {
            width: 100%;
            padding: 14px 16px;
            border: 2px solid rgba(66, 165, 245, 0.3);
            border-radius: 10px;
            background: rgba(26, 26, 46, 0.8);
            color: #E8E8E8;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #42A5F5;
            box-shadow: 0 0 15px rgba(66, 165, 245, 0.3);
        }
        
        .form-group input::placeholder {
            color: #666;
        }
        
        .btn-login {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #66BB6A, #43A047);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 187, 106, 0.4);
        }
        
        .demo-credentials {
            margin-top: 25px;
            padding: 15px;
            background: rgba(255, 167, 38, 0.1);
            border: 1px solid rgba(255, 167, 38, 0.3);
            border-radius: 10px;
        }
        
        .demo-credentials h3 {
            color: #FFA726;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        .demo-credentials p {
            color: #E8E8E8;
            font-size: 13px;
            margin: 5px 0;
            font-family: 'Consolas', monospace;
        }
        
        .demo-credentials span {
            color: #66BB6A;
        }
        
        .footer-links {
            margin-top: 20px;
            text-align: center;
        }
        
        .footer-links a {
            color: #42A5F5;
            text-decoration: none;
            font-size: 14px;
        }
        
        .footer-links a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1>🔒 Secure Login</h1>
            <p>Container-Managed Security Demo</p>
            <span class="badge">JDBC Realm + Form Auth</span>
        </div>
        
        <!--
            KRITISCH: Diese Form-Werte sind Jakarta EE Standard!
            - action="j_security_check" → Container-Endpunkt
            - name="j_username" → Username-Feld
            - name="j_password" → Password-Feld
            
            Diese Namen DÜRFEN NICHT geändert werden!
        -->
        <form method="POST" action="j_security_check">
            <div class="form-group">
                <label for="username">👤 Username</label>
                <input type="text" 
                       id="username" 
                       name="j_username" 
                       placeholder="Dein Benutzername"
                       required 
                       autofocus>
            </div>
            
            <div class="form-group">
                <label for="password">🔑 Password</label>
                <input type="password" 
                       id="password" 
                       name="j_password" 
                       placeholder="Dein Passwort"
                       required>
            </div>
            
            <button type="submit" class="btn-login">
                Anmelden
            </button>
        </form>
        
        <div class="demo-credentials">
            <h3>🧪 Demo-Zugangsdaten:</h3>
            <p><span>admin</span> / admin123 → Admin + User Rechte</p>
            <p><span>john</span> / john123 → Nur User Rechte</p>
            <p><span>jane</span> / jane123 → Nur User Rechte</p>
        </div>
        
        <div class="footer-links">
            <a href="${pageContext.request.contextPath}/">← Zurück zur Startseite</a>
        </div>
    </div>
</body>
</html>
