<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>👋 Erfolgreich abgemeldet</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .logout-container {
            background: rgba(42, 42, 74, 0.95);
            padding: 50px;
            border-radius: 20px;
            text-align: center;
            max-width: 450px;
            border: 1px solid rgba(102, 187, 106, 0.3);
        }
        .icon { font-size: 80px; margin-bottom: 20px; }
        h1 { color: #66BB6A; font-size: 28px; margin-bottom: 15px; }
        p { color: #9E9E9E; font-size: 16px; margin-bottom: 30px; line-height: 1.6; }
        .btn {
            display: inline-block;
            padding: 14px 30px;
            background: linear-gradient(135deg, #42A5F5, #1E88E5);
            color: white;
            border-radius: 10px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn:hover { transform: translateY(-2px); box-shadow: 0 10px 25px rgba(66, 165, 245, 0.4); }
    </style>
</head>
<body>
    <div class="logout-container">
        <div class="icon">👋</div>
        <h1>Erfolgreich abgemeldet!</h1>
        <p>
            Deine Session wurde beendet und du wurdest sicher abgemeldet.
            Bis zum nächsten Mal!
        </p>
        <a href="${pageContext.request.contextPath}/" class="btn">← Zurück zur Startseite</a>
    </div>
</body>
</html>
