# 🏷️ Custom Tags Demo

**Java Web Aufbau – Tag 5 von 10**  
*Von Java Fleet Systems Consulting*

---

## 📋 Übersicht

Dieses Projekt demonstriert **Custom Tags mit SimpleTagSupport**:

- ✅ **Level 1:** Simple Tags (keine Attribute)
- ✅ **Level 2:** Tags mit Attributen
- ✅ **Level 3:** Body Content Processing
- ✅ **TLD:** Tag Library Descriptor

---

## 🗂️ Projektstruktur

```
CustomTagsDemo/
├── pom.xml
├── README.md
├── src/main/
│   ├── java/com/javafleet/tags/
│   │   ├── CopyrightTag.java      # Level 1: Simple Tag
│   │   ├── AlertTag.java          # Level 2: Mit Attributen
│   │   ├── BadgeTag.java          # Level 2: Mit Attributen
│   │   ├── GreetingTag.java       # Level 2: Mit Attributen
│   │   ├── UppercaseTag.java      # Level 3: Body Processing
│   │   ├── PanelTag.java          # Level 3: Body + Attribute
│   │   ├── ShowIfTag.java         # Level 3: Conditional
│   │   ├── TruncateTag.java       # Level 3: Body Transform
│   │   └── RepeatTag.java         # Level 3: Body Repeat
│   └── webapp/
│       ├── WEB-INF/
│       │   └── tlds/
│       │       └── fleet-tags.tld  # Tag Library Descriptor
│       ├── css/
│       │   └── style.css
│       └── index.jsp               # Demo-Seite
```

---

## 🚀 Quick Start

### 1. Projekt bauen

```bash
mvn clean package
```

### 2. WAR deployen

Kopiere `target/CustomTagsDemo.war` in den Server:

**Tomcat 10.x:**
```bash
cp target/CustomTagsDemo.war $TOMCAT_HOME/webapps/
```

**Payara 6.x / GlassFish 7.x:**
```bash
$GLASSFISH_HOME/bin/asadmin deploy target/CustomTagsDemo.war
```

### 3. Im Browser öffnen

```
http://localhost:8080/CustomTagsDemo/
```

---

## 🏷️ Enthaltene Tags

### Level 1: Simple Tags

| Tag | Beschreibung |
|-----|--------------|
| `<fleet:copyright />` | Copyright-Footer mit aktuellem Jahr |

### Level 2: Tags mit Attributen

| Tag | Attribute | Beschreibung |
|-----|-----------|--------------|
| `<fleet:alert />` | type, message, dismissible | Bootstrap Alert-Box |
| `<fleet:badge />` | value, color, pill | Bootstrap Badge |
| `<fleet:greeting />` | name, time, lang | Personalisierte Begrüßung |

### Level 3: Body Content Processing

| Tag | Attribute | Beschreibung |
|-----|-----------|--------------|
| `<fleet:uppercase>` | - | Text in Großbuchstaben |
| `<fleet:panel>` | title, color, icon | Panel mit Header |
| `<fleet:showIf>` | condition | Conditional Rendering |
| `<fleet:truncate>` | maxLength, suffix | Text kürzen |
| `<fleet:repeat>` | times | Body wiederholen |

---

## 📝 Verwendung in JSP

### 1. Taglib importieren

```jsp
<%@ taglib prefix="fleet" uri="http://javafleet.com/tags" %>
```

### 2. Tags verwenden

```jsp
<!-- Level 1: Einfach -->
<fleet:copyright />

<!-- Level 2: Mit Attributen -->
<fleet:alert type="success" message="Done!" />
<fleet:badge value="5" color="danger" />
<fleet:greeting name="${user.name}" lang="de" />

<!-- Level 3: Mit Body -->
<fleet:uppercase>hello world</fleet:uppercase>

<fleet:panel title="Info" color="info">
    <p>Panel-Inhalt hier</p>
</fleet:panel>

<fleet:showIf condition="${user.isAdmin}">
    <p>Nur für Admins sichtbar!</p>
</fleet:showIf>

<fleet:truncate maxLength="50">
    Langer Text wird hier automatisch gekürzt...
</fleet:truncate>

<fleet:repeat times="3">
    <span>⭐</span>
</fleet:repeat>
```

---

## 🔑 Wichtige Konzepte

### 1. SimpleTagSupport

```java
public class MyTag extends SimpleTagSupport {
    @Override
    public void doTag() throws JspException, IOException {
        getJspContext().getOut().write("Output");
    }
}
```

### 2. Attribute mit Setter

```java
private String message;

public void setMessage(String message) {
    this.message = message;
}
```

### 3. Body Content Processing

```java
// Body in Buffer schreiben
StringWriter sw = new StringWriter();
getJspBody().invoke(sw);
String content = sw.toString();

// Oder direkt ausgeben (für Conditionals)
getJspBody().invoke(null);
```

### 4. TLD Struktur

```xml
<tag>
    <name>myTag</name>
    <tag-class>com.example.MyTag</tag-class>
    <body-content>scriptless</body-content>
    <attribute>
        <name>value</name>
        <required>true</required>
        <rtexprvalue>true</rtexprvalue>
    </attribute>
</tag>
```

---

## ⚠️ Häufige Fehler

### "No tag library could be found"

1. Prüfe TLD liegt in `WEB-INF/tlds/`
2. Prüfe URI stimmt überein
3. Server neu starten!

### Attribut bleibt null

- Setter-Name prüfen: `setType()` nicht `settype()`
- JavaBeans-Konvention beachten!

### Body ist null

```java
if (getJspBody() != null) {
    getJspBody().invoke(null);
}
```

---

## 📚 Weiterführende Ressourcen

- [Jakarta JSP Specification](https://jakarta.ee/specifications/pages/)
- [Baeldung: Custom JSP Tags](https://www.baeldung.com/jsp-custom-tags)
- [Java Fleet Blog: Tag 5](https://www.java-developer.online/tag-5custom-tags-tag-handler/)

---

## 👥 Credits

**Entwickelt von:**  
Java Fleet Systems Consulting

**Kurs:**  
Java Web Aufbau – Tag 5 von 10

**Website:**  
https://www.java-developer.online

---

*© 2025 Java Fleet Systems Consulting*
