package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;

/**
 * LEVEL 2: Badge Tag
 * 
 * Erzeugt ein Bootstrap-style Badge mit konfigurierbarer Farbe.
 * 
 * Verwendung in JSP:
 * <fleet:badge value="5" color="danger" />
 * <fleet:badge value="NEW" color="success" />
 * <fleet:badge value="${count}" color="primary" />
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
public class BadgeTag extends SimpleTagSupport {
    
    private String value;
    private String color = "primary";  // Default
    private boolean pill = false;
    
    public String getValue() {
        return value;
    }
    
    public void setValue(String value) {
        this.value = value;
    }
    
    public String getColor() {
        return color;
    }
    
    public void setColor(String color) {
        this.color = color;
    }
    
    public boolean isPill() {
        return pill;
    }
    
    public void setPill(boolean pill) {
        this.pill = pill;
    }
    
    @Override
    public void doTag() throws JspException, IOException {
        if (value == null || value.isEmpty()) {
            return;  // Kein Badge wenn kein Wert
        }
        
        String pillClass = pill ? " badge-pill" : "";
        
        String html = String.format(
            "<span class=\"badge badge-%s%s\">%s</span>",
            color,
            pillClass,
            escapeHtml(value)
        );
        
        getJspContext().getOut().write(html);
    }
    
    private String escapeHtml(String input) {
        if (input == null) return "";
        return input
            .replace("&", "&amp;")
            .replace("<", "&lt;")
            .replace(">", "&gt;");
    }
}
