package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;
import java.time.Year;

/**
 * LEVEL 1: Simple Tag ohne Attribute
 * 
 * Zeigt einen Copyright-Footer mit aktuellem Jahr.
 * Demonstriert die Grundlagen von SimpleTagSupport.
 * 
 * Verwendung in JSP:
 * <fleet:copyright />
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
public class CopyrightTag extends SimpleTagSupport {
    
    @Override
    public void doTag() throws JspException, IOException {
        int currentYear = Year.now().getValue();
        
        String html = String.format("""
            <footer class="copyright">
                <p>© %d Java Fleet Systems Consulting. All rights reserved.</p>
                <p class="tagline">We don't build perfect systems. We build systems that are still maintainable in five years.</p>
            </footer>
            """, currentYear);
        
        getJspContext().getOut().write(html);
    }
}
