package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import jakarta.servlet.jsp.JspException;
import java.io.StringWriter;
import java.io.IOException;

/**
 * BONUS: Panel Tag mit Body und Attributen
 * 
 * Erzeugt ein Bootstrap-style Panel mit Header und Body.
 * Kombiniert Attribute und Body Content Processing.
 * 
 * Verwendung in JSP:
 * <fleet:panel title="User Profile" color="info">
 *     <p>Name: ${user.name}</p>
 *     <p>Email: ${user.email}</p>
 * </fleet:panel>
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
public class PanelTag extends SimpleTagSupport {
    
    private String title;
    private String color = "primary";  // Default
    private String icon = "";
    
    public String getTitle() {
        return title;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getColor() {
        return color;
    }
    
    public void setColor(String color) {
        this.color = color;
    }
    
    public String getIcon() {
        return icon;
    }
    
    public void setIcon(String icon) {
        this.icon = icon;
    }
    
    @Override
    public void doTag() throws JspException, IOException {
        // Validierung
        if (title == null || title.isEmpty()) {
            throw new JspException("Attribut 'title' ist erforderlich!");
        }
        
        // Body Content verarbeiten
        StringWriter bodyContent = new StringWriter();
        if (getJspBody() != null) {
            getJspBody().invoke(bodyContent);
        }
        
        // Icon-Prefix falls vorhanden
        String iconHtml = icon.isEmpty() ? "" : "<span class='panel-icon'>" + icon + "</span> ";
        
        // Panel HTML generieren
        String html = String.format("""
            <div class="panel panel-%s">
                <div class="panel-header">
                    <h3>%s%s</h3>
                </div>
                <div class="panel-body">
                    %s
                </div>
            </div>
            """, 
            color, 
            iconHtml,
            escapeHtml(title), 
            bodyContent.toString()
        );
        
        getJspContext().getOut().write(html);
    }
    
    private String escapeHtml(String input) {
        if (input == null) return "";
        return input
            .replace("&", "&amp;")
            .replace("<", "&lt;")
            .replace(">", "&gt;");
    }
}
