package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;

/**
 * BONUS: Repeat Tag
 * 
 * Wiederholt den Body-Content n-mal.
 * Nützlich für Test-Daten, Prototyping, etc.
 * 
 * Verwendung in JSP:
 * <fleet:repeat times="5">
 *     <div class="item">Item Content</div>
 * </fleet:repeat>
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
public class RepeatTag extends SimpleTagSupport {
    
    private int times = 1;  // Default
    
    public int getTimes() {
        return times;
    }
    
    public void setTimes(int times) {
        if (times < 0) {
            throw new IllegalArgumentException("times darf nicht negativ sein!");
        }
        this.times = times;
    }
    
    @Override
    public void doTag() throws JspException, IOException {
        if (getJspBody() == null) {
            return;
        }
        
        // Body n-mal ausführen
        for (int i = 0; i < times; i++) {
            // invoke(null) = direkt in Output-Stream
            getJspBody().invoke(null);
        }
    }
}
