package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;

/**
 * BONUS: Conditional Tag (wie JSTL c:if)
 * 
 * Zeigt Body nur wenn Bedingung true ist.
 * Demonstriert Control-Flow mit invoke(null).
 * 
 * Verwendung in JSP:
 * <fleet:showIf condition="${user.isAdmin}">
 *     <p>Admin-Bereich sichtbar!</p>
 * </fleet:showIf>
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
public class ShowIfTag extends SimpleTagSupport {
    
    private boolean condition;
    
    public boolean isCondition() {
        return condition;
    }
    
    public void setCondition(boolean condition) {
        this.condition = condition;
    }
    
    @Override
    public void doTag() throws JspException, IOException {
        // Body nur bei TRUE ausführen
        if (condition && getJspBody() != null) {
            // invoke(null) = direkt in Output-Stream schreiben
            getJspBody().invoke(null);
        }
        // Bei FALSE: Nichts tun (Body wird komplett ignoriert)
    }
}
