package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import jakarta.servlet.jsp.JspException;
import java.io.StringWriter;
import java.io.IOException;

/**
 * BONUS: Truncate Tag
 * 
 * Kürzt Text auf eine maximale Länge und fügt "..." hinzu.
 * Nützlich für Vorschau-Texte, Teaser, etc.
 * 
 * Verwendung in JSP:
 * <fleet:truncate maxLength="50">
 *     ${article.content}
 * </fleet:truncate>
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
public class TruncateTag extends SimpleTagSupport {
    
    private int maxLength = 100;  // Default
    private String suffix = "...";
    
    public int getMaxLength() {
        return maxLength;
    }
    
    public void setMaxLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength muss positiv sein!");
        }
        this.maxLength = maxLength;
    }
    
    public String getSuffix() {
        return suffix;
    }
    
    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "...";
    }
    
    @Override
    public void doTag() throws JspException, IOException {
        // Body Content holen
        StringWriter bodyContent = new StringWriter();
        if (getJspBody() != null) {
            getJspBody().invoke(bodyContent);
        }
        
        String content = bodyContent.toString().trim();
        String result;
        
        if (content.length() <= maxLength) {
            // Keine Kürzung nötig
            result = content;
        } else {
            // Kürzen und Suffix anhängen
            // Versuche, an einem Wortende zu kürzen
            int cutPoint = content.lastIndexOf(' ', maxLength);
            if (cutPoint <= 0 || cutPoint < maxLength - 20) {
                // Kein gutes Wortende gefunden, hart abschneiden
                cutPoint = maxLength;
            }
            result = content.substring(0, cutPoint).trim() + suffix;
        }
        
        getJspContext().getOut().write(result);
    }
}
