package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import jakarta.servlet.jsp.JspException;
import java.io.StringWriter;
import java.io.IOException;

/**
 * LEVEL 3: Body Content Processing
 * 
 * Wandelt den Body-Inhalt in Großbuchstaben um.
 * Demonstriert getJspBody().invoke() Pattern.
 * 
 * Verwendung in JSP:
 * <fleet:uppercase>
 *     hello ${user.name}!
 * </fleet:uppercase>
 * 
 * Output: HELLO NOVA!
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
public class UppercaseTag extends SimpleTagSupport {
    
    @Override
    public void doTag() throws JspException, IOException {
        // StringWriter als Buffer für Body-Content
        StringWriter bodyContent = new StringWriter();
        
        // Body in StringWriter ausführen
        // EL und JSTL werden ZUERST evaluiert!
        if (getJspBody() != null) {
            getJspBody().invoke(bodyContent);
        }
        
        // Content in Uppercase umwandeln
        String uppercased = bodyContent.toString().toUpperCase();
        
        // Transformierten Content ausgeben
        getJspContext().getOut().write(uppercased);
    }
}
