<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="fleet" uri="http://javafleet.com/tags" %>
<%@ taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🏷️ Custom Tags Demo - Java Fleet</title>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>🏷️ Custom Tags Demo</h1>
            <p>Java Web Aufbau – Tag 5 von 10</p>
            <div class="badge-container">
                <fleet:badge value="SimpleTagSupport" color="primary" />
                <fleet:badge value="TLD" color="success" />
                <fleet:badge value="Jakarta EE 10" color="info" />
            </div>
        </header>
        
        <!-- ========================================
             LEVEL 1: Simple Tags
             ======================================== -->
        <section class="demo-section level-1">
            <h2>🟢 Level 1: Simple Tags (keine Attribute)</h2>
            <p>Tags ohne Parameter, die statischen Content erzeugen.</p>
            
            <div class="demo-box">
                <h3>Copyright Tag</h3>
                <code>&lt;fleet:copyright /&gt;</code>
                <div class="output">
                    <fleet:copyright />
                </div>
            </div>
        </section>
        
        <!-- ========================================
             LEVEL 2: Tags mit Attributen
             ======================================== -->
        <section class="demo-section level-2">
            <h2>🟡 Level 2: Tags mit Attributen</h2>
            <p>Konfigurierbare, wiederverwendbare Komponenten.</p>
            
            <div class="demo-box">
                <h3>Alert Tag</h3>
                <code>&lt;fleet:alert type="success" message="..." /&gt;</code>
                <div class="output">
                    <fleet:alert type="success" message="Operation erfolgreich abgeschlossen!" />
                    <fleet:alert type="danger" message="Ein Fehler ist aufgetreten!" />
                    <fleet:alert type="warning" message="Achtung: Session läuft bald ab!" />
                    <fleet:alert type="info" message="Hinweis: Neue Features verfügbar." />
                    <fleet:alert type="success" message="Mit Close-Button!" dismissible="true" />
                </div>
            </div>
            
            <div class="demo-box">
                <h3>Badge Tag</h3>
                <code>&lt;fleet:badge value="5" color="danger" /&gt;</code>
                <div class="output">
                    Nachrichten: <fleet:badge value="5" color="danger" />
                    Status: <fleet:badge value="Online" color="success" />
                    Version: <fleet:badge value="1.0" color="info" pill="true" />
                    Neu: <fleet:badge value="NEW" color="warning" />
                </div>
            </div>
            
            <div class="demo-box">
                <h3>Greeting Tag</h3>
                <code>&lt;fleet:greeting name="Nova" lang="de" /&gt;</code>
                <div class="output">
                    <p><fleet:greeting name="Nova" /></p>
                    <p><fleet:greeting name="Elyndra" lang="de" /></p>
                    <p><fleet:greeting name="Franz-Martin" time="morning" lang="de" /></p>
                    <p><fleet:greeting name="Code Sentinel" time="evening" /></p>
                </div>
            </div>
        </section>
        
        <!-- ========================================
             LEVEL 3: Body Content Processing
             ======================================== -->
        <section class="demo-section level-3">
            <h2>🔵 Level 3: Body Content Processing</h2>
            <p>Tags, die den Inhalt zwischen Opening- und Closing-Tag verarbeiten.</p>
            
            <div class="demo-box">
                <h3>Uppercase Tag</h3>
                <code>&lt;fleet:uppercase&gt;text&lt;/fleet:uppercase&gt;</code>
                <div class="output">
                    <p>
                        <fleet:uppercase>
                            hello world! this is a demo of body content processing.
                        </fleet:uppercase>
                    </p>
                </div>
            </div>
            
            <div class="demo-box">
                <h3>Panel Tag</h3>
                <code>&lt;fleet:panel title="..." color="..."&gt;content&lt;/fleet:panel&gt;</code>
                <div class="output">
                    <fleet:panel title="User Information" color="info" icon="👤">
                        <p><strong>Name:</strong> Nova Trent</p>
                        <p><strong>Rolle:</strong> Junior Developer</p>
                        <p><strong>Team:</strong> Java Fleet Systems</p>
                    </fleet:panel>
                    
                    <fleet:panel title="Statistiken" color="success" icon="📊">
                        <ul>
                            <li>Aktive User: 1,234</li>
                            <li>Requests heute: 45,678</li>
                            <li>Server-Uptime: 99.9%</li>
                        </ul>
                    </fleet:panel>
                </div>
            </div>
            
            <div class="demo-box">
                <h3>ShowIf Tag (Conditional)</h3>
                <code>&lt;fleet:showIf condition="true"&gt;...&lt;/fleet:showIf&gt;</code>
                <div class="output">
                    <fleet:showIf condition="${true}">
                        <p class="visible">✓ Dieser Text wird angezeigt (condition=true)</p>
                    </fleet:showIf>
                    
                    <fleet:showIf condition="${false}">
                        <p class="hidden">✗ Dieser Text wird NICHT angezeigt (condition=false)</p>
                    </fleet:showIf>
                    
                    <fleet:showIf condition="${1 + 1 == 2}">
                        <p class="visible">✓ Mathematik funktioniert! (1+1==2)</p>
                    </fleet:showIf>
                </div>
            </div>
            
            <div class="demo-box">
                <h3>Truncate Tag</h3>
                <code>&lt;fleet:truncate maxLength="50"&gt;...&lt;/fleet:truncate&gt;</code>
                <div class="output">
                    <p>Original: "Java Fleet Systems Consulting ist ein fiktives Unternehmen, das Java-Entwickler ausbildet."</p>
                    <p>Gekürzt (50 Zeichen): 
                        <fleet:truncate maxLength="50">
                            Java Fleet Systems Consulting ist ein fiktives Unternehmen, das Java-Entwickler ausbildet.
                        </fleet:truncate>
                    </p>
                    <p>Gekürzt (30 Zeichen, custom suffix): 
                        <fleet:truncate maxLength="30" suffix=" [mehr]">
                            Java Fleet Systems Consulting ist ein fiktives Unternehmen, das Java-Entwickler ausbildet.
                        </fleet:truncate>
                    </p>
                </div>
            </div>
            
            <div class="demo-box">
                <h3>Repeat Tag</h3>
                <code>&lt;fleet:repeat times="5"&gt;...&lt;/fleet:repeat&gt;</code>
                <div class="output">
                    <p>3x wiederholt:</p>
                    <fleet:repeat times="3">
                        <span class="repeated-item">⭐</span>
                    </fleet:repeat>
                    
                    <p style="margin-top: 15px;">5x wiederholt:</p>
                    <fleet:repeat times="5">
                        <div class="repeated-box">Item</div>
                    </fleet:repeat>
                </div>
            </div>
        </section>
        
        <!-- ========================================
             Navigation
             ======================================== -->
        <nav class="demo-nav">
            <a href="${pageContext.request.contextPath}/">← Startseite</a>
            <a href="${pageContext.request.contextPath}/level1-demo.jsp">Level 1 Details →</a>
        </nav>
        
        <!-- Footer mit Copyright Tag -->
        <fleet:copyright />
    </div>
</body>
</html>
