# Setup-Anleitung - Java Web Aufbau Tag 7

## 🎯 Schritt-für-Schritt Installation

---

## 1️⃣ Datenbank Setup

### Option A: Docker (Empfohlen)

```bash
# MySQL Container starten
docker run --name mysql-jpa \
  -e MYSQL_ROOT_PASSWORD=secret \
  -e MYSQL_DATABASE=jpadb \
  -p 3306:3306 \
  -d mysql:8

# Warten bis MySQL bereit ist (ca. 30 Sekunden)
docker logs -f mysql-jpa

# Testen
docker exec -it mysql-jpa mysql -uroot -psecret -e "SHOW DATABASES;"
```

### Option B: Manuell (MySQL bereits installiert)

```bash
# Mit MySQL verbinden
mysql -u root -p

# SQL-Skript ausführen
mysql -u root -p < database_setup.sql

# Oder interaktiv:
mysql> source database_setup.sql;
```

**Connection Details:**
- Host: `localhost`
- Port: `3306`
- Database: `jpadb`
- User: `root`
- Password: `secret`

---

## 2️⃣ Payara Server Setup

### Payara herunterladen (falls noch nicht vorhanden)

```bash
# Download Payara 6.x
wget https://nexus.payara.fish/repository/payara-community/fish/payara/distributions/payara/6.2024.11/payara-6.2024.11.zip

# Entpacken
unzip payara-6.2024.11.zip

# Server starten
cd payara6/bin
./asadmin start-domain
```

**Admin Console:** http://localhost:4848  
**Default Credentials:** admin / (kein Passwort)

---

## 3️⃣ MySQL JDBC Driver in Payara installieren

### Automatisch (empfohlen)

```bash
# Maven dependency wird automatisch ins WAR gepackt
# Oder manuell in Payara lib/ kopieren:
cd payara6/glassfish/domains/domain1/lib
wget https://repo1.maven.org/maven2/com/mysql/mysql-connector-j/8.0.33/mysql-connector-j-8.0.33.jar

# Payara neu starten
./asadmin restart-domain
```

---

## 4️⃣ JDBC Connection Pool konfigurieren

### Via Admin Console (GUI)

1. Öffne: http://localhost:4848
2. Navigiere: **Resources → JDBC → JDBC Connection Pools**
3. Klicke: **New...**
4. Eingeben:
   - **Pool Name**: `MySQLPool`
   - **Resource Type**: `javax.sql.DataSource`
   - **Database Driver Vendor**: `MySQL`
5. **Next**
6. **Additional Properties** setzen:
   ```
   serverName = localhost
   portNumber = 3306
   databaseName = jpadb
   user = root
   password = secret
   ```
7. **Finish**
8. **Ping** testen → Sollte "Ping Succeeded" zeigen!

### Via asadmin (Command Line)

```bash
# Connection Pool erstellen
./asadmin create-jdbc-connection-pool \
  --datasourceclassname com.mysql.cj.jdbc.MysqlDataSource \
  --restype javax.sql.DataSource \
  --property serverName=localhost:portNumber=3306:databaseName=jpadb:user=root:password=secret \
  MySQLPool

# Pool testen
./asadmin ping-connection-pool MySQLPool
```

---

## 5️⃣ JDBC Resource erstellen

### Via Admin Console (GUI)

1. Navigiere: **Resources → JDBC → JDBC Resources**
2. Klicke: **New...**
3. Eingeben:
   - **JNDI Name**: `jdbc/myDB`
   - **Pool Name**: `MySQLPool`
4. **OK**

### Via asadmin (Command Line)

```bash
./asadmin create-jdbc-resource \
  --connectionpoolid MySQLPool \
  jdbc/myDB

# Verifizieren
./asadmin list-jdbc-resources
```

---

## 6️⃣ Projekt bauen

```bash
# Im Projekt-Verzeichnis
cd JavaWebAufbau-Tag7

# Maven Build
mvn clean package

# Ergebnis: target/jpa-beispiele-tag7.war
```

**Bei Build-Problemen:**
```bash
# Maven-Cache löschen
rm -rf ~/.m2/repository/com/javafleet

# Neu bauen
mvn clean install -U
```

---

## 7️⃣ Application deployen

### Via Admin Console (GUI)

1. Navigiere: **Applications**
2. Klicke: **Deploy...**
3. Wähle: `target/jpa-beispiele-tag7.war`
4. **Context Root**: `/jpa-beispiele-tag7` (oder leer für `/`)
5. **OK**

### Via asadmin (Command Line)

```bash
./asadmin deploy \
  --contextroot jpa-beispiele-tag7 \
  target/jpa-beispiele-tag7.war

# Deployment verifizieren
./asadmin list-applications
```

---

## 8️⃣ Anwendung testen

### Öffne im Browser:

```
http://localhost:8080/jpa-beispiele-tag7/
```

### Erwartetes Ergebnis:

✅ Startseite mit Dark Orange/White Theme  
✅ Navigation zu User/Product Management  
✅ Tabellen werden automatisch erstellt (wenn `hibernate.hbm2ddl.auto=update`)

---

## 🔧 Troubleshooting

### Problem 1: "Connection refused" beim Ping

**Ursache:** MySQL läuft nicht oder Port falsch

**Lösung:**
```bash
# Docker: Status prüfen
docker ps -a | grep mysql-jpa

# Logs prüfen
docker logs mysql-jpa

# Neu starten
docker restart mysql-jpa
```

### Problem 2: "Table 'jpadb.users' doesn't exist"

**Ursache:** Auto-Schema-Generation deaktiviert oder fehlgeschlagen

**Lösung:**
```bash
# Option 1: Tabellen manuell erstellen
mysql -u root -p jpadb < database_setup.sql

# Option 2: persistence.xml prüfen
# hibernate.hbm2ddl.auto sollte "update" sein (nur Dev!)
```

### Problem 3: "No Persistence provider for EntityManager"

**Ursache:** Hibernate nicht gefunden

**Lösung:**
1. Prüfe `persistence.xml` liegt in `src/main/resources/META-INF/`
2. Füge Provider hinzu:
```xml
<provider>org.hibernate.jpa.HibernatePersistenceProvider</provider>
```
3. Neu bauen: `mvn clean package`

### Problem 4: ClassNotFoundException für MySQL Driver

**Ursache:** JDBC Driver fehlt

**Lösung:**
```bash
# MySQL Connector in Payara lib/ kopieren
cd payara6/glassfish/domains/domain1/lib
wget https://repo1.maven.org/maven2/com/mysql/mysql-connector-j/8.0.33/mysql-connector-j-8.0.33.jar

# Payara neu starten
./asadmin restart-domain
```

### Problem 5: "Context path /jpa-beispiele-tag7 is already in use"

**Ursache:** App bereits deployed

**Lösung:**
```bash
# Alte Version entfernen
./asadmin undeploy jpa-beispiele-tag7

# Neu deployen
./asadmin deploy target/jpa-beispiele-tag7.war
```

---

## ✅ Verification Checklist

Prüfe folgende Punkte nach dem Setup:

- [ ] MySQL läuft und ist erreichbar
- [ ] Database `jpadb` existiert
- [ ] Payara Server läuft (http://localhost:4848 erreichbar)
- [ ] JDBC Connection Pool `MySQLPool` existiert und Ping erfolgreich
- [ ] JDBC Resource `jdbc/myDB` existiert
- [ ] Application `jpa-beispiele-tag7` deployed
- [ ] Anwendung erreichbar: http://localhost:8080/jpa-beispiele-tag7/
- [ ] User Management funktioniert
- [ ] Product Management funktioniert

---

## 🚀 Nach dem Setup

### Test-Workflow:

1. **User erstellen:**
   - Navigate zu "User Management"
   - Erstelle einen User (z.B. `testuser` / `test@example.com`)
   - Sollte in Liste erscheinen

2. **User suchen:**
   - Suche nach Email-Pattern (z.B. `example`)
   - Sollte gefundene User anzeigen

3. **Product erstellen:**
   - Navigate zu "Product Management"
   - Erstelle ein Product (z.B. `Test Product` / `19.99` / `5`)
   - Sollte in Liste erscheinen

4. **Stock aktualisieren:**
   - Ändere Stock-Wert inline
   - Sollte sofort aktualisiert werden (Dirty Checking!)

5. **Low Stock Filter:**
   - Klicke "Low Stock"
   - Sollte nur Products mit Stock ≤10 anzeigen

### Logs prüfen:

```bash
# Payara Logs
tail -f payara6/glassfish/domains/domain1/logs/server.log

# SQL-Queries sehen (wenn show_sql=true)
# Sollte im Server-Log erscheinen
```

---

## 📚 Nächste Schritte

Nach erfolgreichem Setup:

1. **Code erkunden:**
   - Lies `User.java` und `Product.java` Entities
   - Verstehe `UserService.java` CRUD-Operationen
   - Schaue `persistence.xml` Konfiguration an

2. **Tutorial durcharbeiten:**
   - https://www.java-developer.online/tag7-jpa-vs-jdbc-konfiguration-provider/

3. **Challenge lösen:**
   - Erweitere Product Entity um weitere Felder
   - Implementiere zusätzliche Queries
   - Füge weitere Validierungen hinzu

4. **Weiter zu Tag 8:**
   - JPA Relationen (@OneToOne, @ManyToOne)

---

**Viel Erfolg! 🚀**

Bei Problemen: feedback@java-developer.online
