-- ============================================
-- Java Web Aufbau - Tag 7
-- Datenbank Setup Script für MySQL 8.0+
-- ============================================

-- Datenbank erstellen (falls nicht vorhanden)
CREATE DATABASE IF NOT EXISTS jpadb 
    CHARACTER SET utf8mb4 
    COLLATE utf8mb4_unicode_ci;

USE jpadb;

-- ============================================
-- 1. User Tabelle
-- ============================================
DROP TABLE IF EXISTS users;

CREATE TABLE users (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    email VARCHAR(100) NOT NULL,
    created_at DATETIME,
    
    INDEX idx_username (username),
    INDEX idx_email (email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Test-Daten für Users (optional)
INSERT INTO users (username, email, created_at) VALUES
    ('elyndra_v', 'elyndra@javafleet.com', NOW()),
    ('nova_t', 'nova@javafleet.com', NOW()),
    ('cassian_h', 'cassian@javafleet.com', NOW());

-- ============================================
-- 2. Product Tabelle (Challenge)
-- ============================================
DROP TABLE IF EXISTS products;

CREATE TABLE products (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    stock INT NOT NULL DEFAULT 0,
    created_at DATETIME,
    
    INDEX idx_name (name),
    INDEX idx_stock (stock)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Test-Daten für Products (optional)
INSERT INTO products (name, price, stock, created_at) VALUES
    ('Java for Dummies', 29.99, 15, NOW()),
    ('Effective Java (3rd Edition)', 44.99, 8, NOW()),
    ('Clean Code', 39.99, 3, NOW()),
    ('Head First Design Patterns', 34.99, 0, NOW()),
    ('Spring Boot in Action', 49.99, 25, NOW());

-- ============================================
-- Verify Setup
-- ============================================
SELECT 'Users Table' AS table_name, COUNT(*) AS row_count FROM users
UNION ALL
SELECT 'Products Table' AS table_name, COUNT(*) AS row_count FROM products;

-- ============================================
-- Nützliche Queries zum Testen
-- ============================================

-- Alle User anzeigen
-- SELECT * FROM users ORDER BY created_at DESC;

-- User per Email suchen
-- SELECT * FROM users WHERE email LIKE '%javafleet%';

-- Alle Products anzeigen
-- SELECT * FROM products ORDER BY name;

-- Low Stock Products (≤10)
-- SELECT * FROM products WHERE stock <= 10 ORDER BY stock;

-- Products nach Preis sortiert
-- SELECT * FROM products ORDER BY price DESC;

-- Stock-Wert berechnen
-- SELECT 
--     name, 
--     price, 
--     stock, 
--     (price * stock) AS total_value 
-- FROM products 
-- ORDER BY total_value DESC;
