package com.javafleet.model;

import jakarta.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Product Entity - Challenge Beispiel
 * 
 * Requirements aus der Challenge:
 * - Auto-generated ID
 * - Name (max 100 Zeichen, NOT NULL)
 * - Price (BigDecimal, NOT NULL)
 * - Stock (Integer, default 0)
 * - CreatedAt Timestamp
 * - Named Query für findAll
 */
@Entity
@Table(name = "products")
@NamedQuery(
    name = "Product.findAll",
    query = "SELECT p FROM Product p ORDER BY p.name"
)
public class Product {
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    
    @Column(name = "name", nullable = false, length = 100)
    private String name;
    
    @Column(name = "price", nullable = false, precision = 10, scale = 2)
    private BigDecimal price;
    
    @Column(name = "stock", nullable = false)
    private Integer stock = 0;  // Default 0
    
    @Column(name = "created_at")
    private LocalDateTime createdAt;
    
    // Default Constructor
    public Product() {
    }
    
    public Product(String name, BigDecimal price) {
        this.name = name;
        this.price = price;
        this.stock = 0;
    }
    
    public Product(String name, BigDecimal price, Integer stock) {
        this.name = name;
        this.price = price;
        this.stock = stock;
    }
    
    @PrePersist
    protected void onCreate() {
        createdAt = LocalDateTime.now();
        if (stock == null) {
            stock = 0;
        }
    }
    
    // Getters & Setters
    
    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public String getName() {
        return name;
    }
    
    public void setName(String name) {
        this.name = name;
    }
    
    public BigDecimal getPrice() {
        return price;
    }
    
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    
    public Integer getStock() {
        return stock;
    }
    
    public void setStock(Integer stock) {
        this.stock = stock;
    }
    
    public LocalDateTime getCreatedAt() {
        return createdAt;
    }
    
    @Override
    public String toString() {
        return "Product{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", price=" + price +
                ", stock=" + stock +
                ", createdAt=" + createdAt +
                '}';
    }
}
