package com.javafleet.model;

import jakarta.persistence.*;
import java.time.LocalDateTime;

/**
 * User Entity - Grundlagen Beispiel
 * 
 * Zeigt:
 * - @Entity und @Table Annotations
 * - Primary Key mit @Id und @GeneratedValue
 * - @Column mit Constraints
 * - @PrePersist Lifecycle Callback
 * - Default Constructor (PFLICHT für JPA!)
 */
@Entity
@Table(name = "users")
@NamedQuery(
    name = "User.findByEmail",
    query = "SELECT u FROM User u WHERE u.email = :email"
)
public class User {
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    
    @Column(name = "username", nullable = false, unique = true, length = 50)
    private String username;
    
    @Column(name = "email", nullable = false, length = 100)
    private String email;
    
    @Column(name = "created_at")
    private LocalDateTime createdAt;
    
    // Default Constructor (PFLICHT für JPA!)
    public User() {
    }
    
    public User(String username, String email) {
        this.username = username;
        this.email = email;
    }
    
    /**
     * Lifecycle Callback - wird VOR persist() aufgerufen
     * Perfekt für Timestamps!
     */
    @PrePersist
    protected void onCreate() {
        createdAt = LocalDateTime.now();
    }
    
    // Getters & Setters
    
    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public String getUsername() {
        return username;
    }
    
    public void setUsername(String username) {
        this.username = username;
    }
    
    public String getEmail() {
        return email;
    }
    
    public void setEmail(String email) {
        this.email = email;
    }
    
    public LocalDateTime getCreatedAt() {
        return createdAt;
    }
    
    @Override
    public String toString() {
        return "User{" +
                "id=" + id +
                ", username='" + username + '\'' +
                ", email='" + email + '\'' +
                ", createdAt=" + createdAt +
                '}';
    }
}
