<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management - Java Web Aufbau Tag 7</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="container fade-in">
        <header>
            <h1>👥 User Management</h1>
            <p>EntityManager CRUD Demo</p>
        </header>
        
        <nav>
            <a href="index.jsp">🏠 Home</a>
            <a href="users">👥 User Management</a>
            <a href="products">📦 Product Management</a>
        </nav>
        
        <!-- Success/Error Messages -->
        <c:if test="${not empty success}">
            <div class="message success">
                ✅ ${success}
            </div>
        </c:if>
        
        <c:if test="${not empty error}">
            <div class="message error">
                ❌ ${error}
            </div>
        </c:if>
        
        <!-- Create User Form -->
        <div class="card">
            <h2>Neuen User erstellen</h2>
            <p style="margin-bottom: 20px; color: #999;">
                Nutzt <code>em.persist(user)</code> - INSERT beim Transaction-Commit
            </p>
            
            <form method="post" action="users">
                <div class="form-group">
                    <label for="username">Username:</label>
                    <input type="text" id="username" name="username" 
                           placeholder="z.B. elyndra_v" required>
                </div>
                
                <div class="form-group">
                    <label for="email">Email:</label>
                    <input type="email" id="email" name="email" 
                           placeholder="z.B. elyndra@javafleet.com" required>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    ➕ User erstellen
                </button>
            </form>
        </div>
        
        <!-- Search Form -->
        <div class="card">
            <h2>User suchen</h2>
            <p style="margin-bottom: 20px; color: #999;">
                JPQL Query: <code>SELECT u FROM User u WHERE u.email LIKE :pattern</code>
            </p>
            
            <form method="get" action="users">
                <input type="hidden" name="action" value="search">
                <div class="form-group">
                    <label for="searchEmail">Email-Pattern:</label>
                    <input type="text" id="searchEmail" name="email" 
                           placeholder="z.B. gmail" value="${searchTerm}">
                </div>
                
                <button type="submit" class="btn btn-primary">
                    🔍 Suchen
                </button>
                <a href="users" class="btn" style="background: #363636; color: #fff; margin-left: 10px;">
                    🔄 Alle anzeigen
                </a>
            </form>
        </div>
        
        <!-- User List -->
        <div class="card">
            <h2>User Liste</h2>
            <p style="margin-bottom: 20px; color: #999;">
                <c:choose>
                    <c:when test="${not empty searchTerm}">
                        Suchergebnisse für: <strong>"${searchTerm}"</strong> (${count} gefunden)
                    </c:when>
                    <c:otherwise>
                        Gesamt: <strong>${count}</strong> User(s)
                    </c:otherwise>
                </c:choose>
            </p>
            
            <c:choose>
                <c:when test="${empty users}">
                    <div style="background: #363636; padding: 30px; text-align: center; border-radius: 8px;">
                        <p style="font-size: 1.2em;">Noch keine User vorhanden.</p>
                        <p style="margin-top: 10px; color: #999;">Erstelle deinen ersten User oben! 👆</p>
                    </div>
                </c:when>
                <c:otherwise>
                    <table>
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Username</th>
                                <th>Email</th>
                                <th>Erstellt am</th>
                                <th>Aktionen</th>
                            </tr>
                        </thead>
                        <tbody>
                            <c:forEach var="user" items="${users}">
                                <tr>
                                    <td><strong>#${user.id}</strong></td>
                                    <td>${user.username}</td>
                                    <td>${user.email}</td>
                                    <td>
                                        <c:choose>
                                            <c:when test="${not empty user.createdAt}">
                                                ${user.createdAt.toString().substring(0, 19).replace('T', ' ')}
                                            </c:when>
                                            <c:otherwise>
                                                -
                                            </c:otherwise>
                                        </c:choose>
                                    </td>
                                    <td>
                                        <form method="get" action="users" style="display: inline; background: none; padding: 0;">
                                            <input type="hidden" name="action" value="delete">
                                            <input type="hidden" name="id" value="${user.id}">
                                            <button type="submit" class="btn btn-danger btn-small" 
                                                    onclick="return confirm('User ${user.username} wirklich löschen?')">
                                                🗑️ Löschen
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            </c:forEach>
                        </tbody>
                    </table>
                </c:otherwise>
            </c:choose>
        </div>
        
        <!-- Code Explanation -->
        <div class="card">
            <h2>💡 Was passiert hier?</h2>
            <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; margin-top: 15px; border-left: 5px solid #28a745;">
                <h3 style="color: #28a745; margin-bottom: 15px;">CREATE (persist)</h3>
                <pre style="background: #000; padding: 15px; border-radius: 5px; overflow-x: auto; color: #fff; line-height: 1.6;"><code>User user = new User(username, email);
em.persist(user);  // INSERT beim Transaction-Commit</code></pre>
            </div>
            
            <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; margin-top: 15px; border-left: 5px solid #ffc107;">
                <h3 style="color: #ffc107; margin-bottom: 15px;">READ (find)</h3>
                <pre style="background: #000; padding: 15px; border-radius: 5px; overflow-x: auto; color: #fff; line-height: 1.6;"><code>User user = em.find(User.class, id);  // SELECT per Primary Key</code></pre>
            </div>
            
            <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; margin-top: 15px; border-left: 5px solid #17a2b8;">
                <h3 style="color: #17a2b8; margin-bottom: 15px;">QUERY (JPQL)</h3>
                <pre style="background: #000; padding: 15px; border-radius: 5px; overflow-x: auto; color: #fff; line-height: 1.6;"><code>List&lt;User&gt; users = em.createQuery(
    "SELECT u FROM User u WHERE u.email LIKE :pattern", User.class)
    .setParameter("pattern", "%" + pattern + "%")
    .getResultList();</code></pre>
            </div>
            
            <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; margin-top: 15px; border-left: 5px solid #dc3545;">
                <h3 style="color: #dc3545; margin-bottom: 15px;">DELETE (remove)</h3>
                <pre style="background: #000; padding: 15px; border-radius: 5px; overflow-x: auto; color: #fff; line-height: 1.6;"><code>User user = em.find(User.class, id);
if (user != null) {
    em.remove(user);  // DELETE beim Transaction-Commit
}</code></pre>
            </div>
        </div>
        
        <footer>
            <p><strong>User Management Demo</strong></p>
            <p style="margin-top: 10px;">
                Teil von: Java Web Aufbau - Tag 7
            </p>
        </footer>
    </div>
</body>
</html>
