<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Java Web Aufbau - Tag 7</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="container fade-in">
        <header>
            <h1>🚀 Java Web Aufbau - Tag 7</h1>
            <p>JPA vs JDBC - Konfiguration & Provider</p>
            <p style="margin-top: 10px; font-size: 0.9em;">Von Elyndra Valen | Java Fleet Systems Consulting</p>
        </header>
        
        <nav>
            <a href="index.jsp">🏠 Home</a>
            <a href="users">👥 User Management</a>
            <a href="products">📦 Product Management</a>
        </nav>
        
        <div class="card">
            <h2>Willkommen! 👋</h2>
            <p style="line-height: 1.8; font-size: 1.1em;">
                Diese Anwendung demonstriert alle Code-Beispiele aus dem Tutorial 
                <strong>"Tag 7: JPA vs JDBC - Konfiguration & Provider"</strong>.
            </p>
            <p style="margin-top: 15px; line-height: 1.8; font-size: 1.1em;">
                Du findest hier:
            </p>
            <ul style="margin-top: 15px; margin-left: 30px; line-height: 2;">
                <li>✅ <strong>User Management</strong> - CRUD mit EntityManager</li>
                <li>✅ <strong>Product Management</strong> - Challenge-Lösung</li>
                <li>✅ Entity-Klassen mit <code>@Entity</code>, <code>@Id</code>, <code>@Column</code></li>
                <li>✅ <code>persistence.xml</code> Konfiguration</li>
                <li>✅ Named Queries und JPQL</li>
                <li>✅ Dirty Checking Demo</li>
            </ul>
        </div>
        
        <div class="card">
            <h2>📋 Projekt-Features</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                <div style="background: #363636; padding: 20px; border-radius: 8px; border-left: 3px solid #28a745;">
                    <h3 style="color: #28a745; margin-bottom: 10px;">User Management</h3>
                    <p style="font-size: 0.95em; line-height: 1.6;">
                        Vollständiges CRUD mit EntityManager:<br>
                        • persist()<br>
                        • find()<br>
                        • remove()<br>
                        • JPQL Queries
                    </p>
                </div>
                
                <div style="background: #363636; padding: 20px; border-radius: 8px; border-left: 3px solid #ffc107;">
                    <h3 style="color: #ffc107; margin-bottom: 10px;">Product Management</h3>
                    <p style="font-size: 0.95em; line-height: 1.6;">
                        Challenge-Lösung:<br>
                        • Stock-Verwaltung<br>
                        • Named Queries<br>
                        • Dirty Checking<br>
                        • Low-Stock Filter
                    </p>
                </div>
                
                <div style="background: #363636; padding: 20px; border-radius: 8px; border-left: 3px solid #dc3545;">
                    <h3 style="color: #dc3545; margin-bottom: 10px;">JPA Best Practices</h3>
                    <p style="font-size: 0.95em; line-height: 1.6;">
                        Production-Ready:<br>
                        • DataSource (JNDI)<br>
                        • Transaction Management<br>
                        • Error Handling<br>
                        • Performance Tuning
                    </p>
                </div>
            </div>
        </div>
        
        <div class="card">
            <h2>🎯 Lernziele</h2>
            <div style="background: #363636; padding: 20px; border-radius: 8px; margin-top: 15px;">
                <p style="margin-bottom: 15px; font-size: 1.05em;">Nach diesem Projekt beherrschst du:</p>
                <ol style="margin-left: 25px; line-height: 2; font-size: 1.05em;">
                    <li>Den Unterschied zwischen JDBC und JPA verstehen</li>
                    <li><code>persistence.xml</code> konfigurieren (Dev & Production)</li>
                    <li>Entity-Klassen mit richtigen Annotations erstellen</li>
                    <li>EntityManager für alle CRUD-Operationen nutzen</li>
                    <li>JPQL und Named Queries schreiben</li>
                    <li>Dirty Checking in der Praxis anwenden</li>
                    <li>DataSource über JNDI einbinden</li>
                    <li>Transaction Management mit <code>@Stateless</code></li>
                </ol>
            </div>
        </div>
        
        <div class="card">
            <h2>🚀 Quick Start</h2>
            <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; margin-top: 15px; border: 2px solid #ff6600;">
                <h3 style="color: #ff6600; margin-bottom: 15px;">1. Datenbank starten (Docker)</h3>
                <pre style="background: #000; padding: 15px; border-radius: 5px; overflow-x: auto; color: #28a745;">docker run --name mysql-jpa -e MYSQL_ROOT_PASSWORD=secret \
  -e MYSQL_DATABASE=jpadb -p 3306:3306 -d mysql:8</pre>
                
                <h3 style="color: #ff6600; margin-top: 25px; margin-bottom: 15px;">2. DataSource in Payara konfigurieren</h3>
                <p style="margin-bottom: 10px;">Admin Console → Resources → JDBC:</p>
                <ul style="margin-left: 25px; line-height: 1.8;">
                    <li>Connection Pool: <code>MySQLPool</code></li>
                    <li>JDBC Resource: <code>jdbc/myDB</code></li>
                    <li>Server: <code>localhost:3306</code></li>
                    <li>Database: <code>jpadb</code></li>
                </ul>
                
                <h3 style="color: #ff6600; margin-top: 25px; margin-bottom: 15px;">3. Projekt deployen</h3>
                <pre style="background: #000; padding: 15px; border-radius: 5px; overflow-x: auto; color: #28a745;">mvn clean package
# WAR in Payara deployen via Admin Console</pre>
            </div>
        </div>
        
        <footer>
            <p><strong>Java Web Aufbau - Tag 7 von 10</strong></p>
            <p style="margin-top: 10px;">
                Tutorial: <a href="https://www.java-developer.online" target="_blank">java-developer.online</a>
            </p>
            <p style="margin-top: 10px;">
                © 2025 Java Fleet Systems Consulting
            </p>
        </footer>
    </div>
</body>
</html>
