# Java OOP - Tag 1: Starter-Projekt

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 1 von 10  
**Thema:** OOP-Konzepte & erste Klasse  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

### Voraussetzungen

- **Java 21** (Amazon Corretto empfohlen)
- **Maven 3.8+**

### Projekt ausführen

```bash
# In das Projektverzeichnis wechseln
cd Tag01_OOP_Starter

# Kompilieren
mvn compile

# Ausführen
mvn exec:java
```

### Alternative: JAR erstellen

```bash
mvn package
java -jar target/oop-tag01-starter-1.0.0.jar
```

---

## 📁 Projektstruktur

```
Tag01_OOP_Starter/
├── pom.xml                              # Maven Konfiguration
├── README.md                            # Diese Datei
└── src/
    └── main/
        └── java/
            └── de/javafleet/oop/
                ├── Main.java            # Einstiegspunkt
                └── model/
                    └── Auto.java        # Beispielklasse
```

---

## 📝 Deine Aufgabe

1. **Führe das Projekt aus** und schau dir die Ausgabe an
2. **Öffne `Main.java`** und finde den TODO-Kommentar
3. **Erstelle ein drittes Auto-Objekt** mit eigenen Werten
4. **Experimentiere:** Was passiert, wenn du die Werte änderst?

---

## 🎯 Was du lernst

Nach diesem Tag kannst du:

- ✅ Den Unterschied zwischen Klasse und Objekt erklären
- ✅ Eine eigene Klasse mit Attributen und Methoden schreiben
- ✅ Objekte mit `new` erzeugen
- ✅ Attribute setzen und Methoden aufrufen
- ✅ Pakete (Packages) verstehen und verwenden

---

## 🔗 Weiterführende Links

- [Tag 1 Blogpost](https://java-developer.online/kurse/java-oop/tag-1)
- [Oracle Java Tutorials - Classes](https://docs.oracle.com/javase/tutorial/java/javaOO/classes.html)

---

## 💬 Fragen?

Schreib uns: **nova@java-developer.online**

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
