package de.javafleet.oop;

import de.javafleet.oop.model.Auto;

/**
 * Einstiegspunkt für das Tag 1 Projekt.
 * 
 * Hier siehst du, wie Objekte erzeugt und verwendet werden.
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════╗");
        System.out.println("║   Java OOP - Tag 1: Erste Objekte     ║");
        System.out.println("╚═══════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // OBJEKTE ERZEUGEN
        // ========================================
        
        // Erstes Auto-Objekt erzeugen
        Auto meinAuto = new Auto();
        
        // Attribute setzen
        meinAuto.farbe = "Rot";
        meinAuto.ps = 150;
        meinAuto.marke = "VW";
        
        // Zweites Auto-Objekt erzeugen (komplett unabhängig!)
        Auto deinAuto = new Auto();
        deinAuto.farbe = "Blau";
        deinAuto.ps = 200;
        deinAuto.marke = "BMW";
        
        
        // ========================================
        // OBJEKTE VERWENDEN
        // ========================================
        
        System.out.println(">>> Mein Auto:");
        meinAuto.info();
        meinAuto.fahren();
        meinAuto.hupen();
        
        System.out.println();
        
        System.out.println(">>> Dein Auto:");
        deinAuto.info();
        deinAuto.fahren();
        deinAuto.bremsen();
        
        System.out.println();
        System.out.println("✅ Tag 1 geschafft! Du hast deine ersten Objekte erstellt.");
        System.out.println();
        
        // ========================================
        // DEINE AUFGABE
        // ========================================
        
        System.out.println("📝 DEINE AUFGABE:");
        System.out.println("   1. Erstelle ein drittes Auto-Objekt");
        System.out.println("   2. Gib ihm eigene Werte für farbe, ps und marke");
        System.out.println("   3. Rufe die Methoden auf");
        System.out.println();
        System.out.println("   Viel Erfolg! 🚀");
        
        // TODO: Dein Code hier...
        
    }
}
