package de.javafleet.oop.model;

/**
 * Beispielklasse für Tag 1: OOP-Konzepte & erste Klasse.
 * 
 * Eine Klasse ist ein Bauplan für Objekte.
 * Diese Klasse beschreibt, was ein Auto HAT (Attribute)
 * und was ein Auto KANN (Methoden).
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Auto {
    
    // ========================================
    // ATTRIBUTE (Was HAT ein Auto?)
    // ========================================
    
    /**
     * Die Farbe des Autos (z.B. "Rot", "Blau").
     */
    String farbe;
    
    /**
     * Die Leistung in PS.
     */
    int ps;
    
    /**
     * Die Marke des Autos (z.B. "VW", "BMW").
     */
    String marke;
    
    
    // ========================================
    // METHODEN (Was KANN ein Auto?)
    // ========================================
    
    /**
     * Das Auto fährt los.
     * Gibt eine Nachricht auf der Konsole aus.
     */
    void fahren() {
        System.out.println("Das " + farbe + "e " + marke + " fährt los! 🚗");
    }
    
    /**
     * Das Auto hupt.
     */
    void hupen() {
        System.out.println("HUUUP! 📢");
    }
    
    /**
     * Das Auto bremst.
     */
    void bremsen() {
        System.out.println("Das Auto bremst... *quietsch*");
    }
    
    /**
     * Gibt Informationen über das Auto aus.
     */
    void info() {
        System.out.println("=== Auto-Info ===");
        System.out.println("Marke: " + marke);
        System.out.println("Farbe: " + farbe);
        System.out.println("Leistung: " + ps + " PS");
        System.out.println("=================");
    }
}
