# Java OOP - Tag 2: Attribute & Methoden

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 2 von 10  
**Thema:** Attribute, Methoden, this-Referenz, Methodenüberladung  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

### Voraussetzungen

- **Java 21** (Amazon Corretto empfohlen)
- **Maven 3.8+**

### Projekt ausführen

```bash
cd Tag02_Attribute_Methoden
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag02_Attribute_Methoden/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java            # Einstiegspunkt mit Beispielen
        └── model/
            └── Auto.java        # Erweiterte Klasse mit Methoden
```

---

## 📝 Was dieses Projekt demonstriert

### Instanzvariablen (Attribute)
```java
String farbe;
int kilometerstand = 0;
double tankinhalt = 50.0;
```

### Setter mit this-Referenz
```java
void setFarbe(String farbe) {
    this.farbe = farbe;  // Unterscheidet Attribut vom Parameter
}
```

### Getter mit Rückgabewert
```java
String getFarbe() {
    return farbe;
}
```

### Methodenüberladung
```java
void fahren() { }                    // Version 1
void fahren(int km) { }              // Version 2
void fahren(int km, String ziel) { } // Version 3
void fahren(String ziel) { }         // Version 4
```

---

## 🎯 Deine Aufgabe

1. **Führe das Projekt aus** und studiere die Ausgabe
2. **Erstelle ein zweites Auto-Objekt** mit eigenen Werten
3. **Experimentiere mit den überladenen Methoden**
4. **Bonus:** Füge eine Methode `hupen(int anzahl)` hinzu

---

## 🔗 Weiterführende Links

- [Tag 2 Blogpost](https://java-developer.online/kurse/java-oop/tag-2)
- [Oracle — Defining Methods](https://docs.oracle.com/javase/tutorial/java/javaOO/methods.html)

---

## 💬 Fragen?

Schreib uns: **nova@java-developer.online**

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
