package de.javafleet.oop;

import de.javafleet.oop.model.Auto;

/**
 * Einstiegspunkt für das Tag 2 Projekt.
 * 
 * Demonstriert:
 * - Getter und Setter mit this
 * - Methoden mit Parametern
 * - Methoden mit Rückgabewerten
 * - Methodenüberladung
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════════════╗");
        System.out.println("║   Java OOP - Tag 2: Attribute & Methoden      ║");
        System.out.println("╚═══════════════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // OBJEKT MIT SETTERN INITIALISIEREN
        // ========================================
        
        System.out.println(">>> Auto erstellen und mit Settern konfigurieren:");
        System.out.println();
        
        Auto meinAuto = new Auto();
        
        // Setter verwenden (statt direktem Zugriff)
        meinAuto.setFarbe("Rot");
        meinAuto.setPs(150);
        meinAuto.setMarke("VW Golf");
        
        // Info anzeigen
        meinAuto.info();
        System.out.println();
        
        
        // ========================================
        // METHODENÜBERLADUNG DEMONSTRIEREN
        // ========================================
        
        System.out.println(">>> Methodenüberladung testen:");
        System.out.println();
        
        // Version 1: Keine Parameter
        meinAuto.fahren();
        
        // Version 2: Mit Kilometern
        meinAuto.fahren(50);
        
        // Version 3: Mit Kilometern und Ziel
        meinAuto.fahren(120, "Hamburg");
        
        // Version 4: Nur Ziel
        meinAuto.fahren("Berlin");
        
        System.out.println();
        
        
        // ========================================
        // GETTER UND RÜCKGABEWERTE
        // ========================================
        
        System.out.println(">>> Getter und Berechnungen:");
        System.out.println();
        
        int km = meinAuto.getKilometerstand();
        System.out.println("Aktueller Kilometerstand: " + km + " km");
        
        double reichweite = meinAuto.berechneReichweite();
        System.out.println("Aktuelle Reichweite: " + String.format("%.0f", reichweite) + " km");
        
        System.out.println();
        
        
        // ========================================
        // TANKEN UND WEITERFAHREN
        // ========================================
        
        System.out.println(">>> Tanken und weiterfahren:");
        System.out.println();
        
        meinAuto.tanken(30);
        meinAuto.fahren(200);
        
        System.out.println();
        
        // Finale Info
        System.out.println(">>> Finaler Zustand:");
        meinAuto.info();
        
        System.out.println();
        System.out.println("✅ Tag 2 geschafft!");
        System.out.println();
        
        
        // ========================================
        // DEINE AUFGABE
        // ========================================
        
        System.out.println("╔═══════════════════════════════════════════════╗");
        System.out.println("║               DEINE AUFGABE                   ║");
        System.out.println("╠═══════════════════════════════════════════════╣");
        System.out.println("║ 1. Erstelle ein zweites Auto-Objekt           ║");
        System.out.println("║ 2. Verwende die Setter zum Konfigurieren      ║");
        System.out.println("║ 3. Lass beide Autos unterschiedliche          ║");
        System.out.println("║    Strecken fahren                            ║");
        System.out.println("║ 4. Vergleiche die Kilometerstände mit         ║");
        System.out.println("║    getKilometerstand()                        ║");
        System.out.println("║                                               ║");
        System.out.println("║ Bonus: Füge eine Methode hupen(int anzahl)    ║");
        System.out.println("║        hinzu, die X-mal hupt!                 ║");
        System.out.println("╚═══════════════════════════════════════════════╝");
        System.out.println();
        
        // TODO: Dein Code hier...
        
    }
}
