package de.javafleet.oop.model;

/**
 * Erweiterte Auto-Klasse für Tag 2: Attribute & Methoden.
 * 
 * Demonstriert:
 * - Instanzvariablen (Attribute)
 * - Methoden mit Parametern
 * - Methoden mit Rückgabewerten
 * - Die this-Referenz
 * - Methodenüberladung (Overloading)
 * 
 * @author Nova Trent
 * @version 2.0
 */
public class Auto {
    
    // ========================================
    // INSTANZVARIABLEN (Attribute)
    // ========================================
    
    /**
     * Die Farbe des Autos.
     */
    String farbe;
    
    /**
     * Die Leistung in PS.
     */
    int ps;
    
    /**
     * Die Marke des Autos.
     */
    String marke;
    
    /**
     * Der aktuelle Kilometerstand.
     */
    int kilometerstand = 0;
    
    /**
     * Der Tankinhalt in Litern.
     */
    double tankinhalt = 50.0;
    
    /**
     * Durchschnittsverbrauch in Liter pro 100km.
     */
    double verbrauch = 7.5;
    
    
    // ========================================
    // SETTER-METHODEN (mit this-Referenz)
    // ========================================
    
    /**
     * Setzt die Farbe des Autos.
     * Demonstriert die Verwendung von this.
     * 
     * @param farbe Die neue Farbe
     */
    void setFarbe(String farbe) {
        // this.farbe = Attribut
        // farbe = Parameter
        this.farbe = farbe;
    }
    
    /**
     * Setzt die PS-Zahl.
     * 
     * @param ps Die neue PS-Zahl
     */
    void setPs(int ps) {
        this.ps = ps;
    }
    
    /**
     * Setzt die Marke.
     * 
     * @param marke Die neue Marke
     */
    void setMarke(String marke) {
        this.marke = marke;
    }
    
    
    // ========================================
    // GETTER-METHODEN (mit Rückgabewert)
    // ========================================
    
    /**
     * Gibt die Farbe zurück.
     * 
     * @return Die aktuelle Farbe
     */
    String getFarbe() {
        return farbe;
    }
    
    /**
     * Gibt die PS-Zahl zurück.
     * 
     * @return Die aktuelle PS-Zahl
     */
    int getPs() {
        return ps;
    }
    
    /**
     * Gibt den Kilometerstand zurück.
     * 
     * @return Der aktuelle Kilometerstand
     */
    int getKilometerstand() {
        return kilometerstand;
    }
    
    
    // ========================================
    // ÜBERLADENE METHODEN (Overloading)
    // ========================================
    
    /**
     * Das Auto fährt los (ohne Kilometerangabe).
     * Version 1: Keine Parameter
     */
    void fahren() {
        System.out.println("Das " + farbe + "e " + marke + " fährt los! 🚗");
    }
    
    /**
     * Das Auto fährt eine bestimmte Strecke.
     * Version 2: Mit Kilometerangabe
     * 
     * @param km Die zu fahrenden Kilometer
     */
    void fahren(int km) {
        // Berechne Benzinverbrauch (lokale Variable!)
        double benzinBedarf = (km / 100.0) * verbrauch;
        
        if (benzinBedarf > tankinhalt) {
            System.out.println("⚠️ Nicht genug Benzin! Brauche " + 
                benzinBedarf + " Liter, habe nur " + tankinhalt + " Liter.");
            return;
        }
        
        // Fahrt durchführen
        kilometerstand = kilometerstand + km;
        tankinhalt = tankinhalt - benzinBedarf;
        
        System.out.println("Fahre " + km + " km. Kilometerstand jetzt: " + 
            kilometerstand + " km. Tank: " + String.format("%.1f", tankinhalt) + " L");
    }
    
    /**
     * Das Auto fährt zu einem bestimmten Ziel.
     * Version 3: Mit Kilometer und Ziel
     * 
     * @param km Die zu fahrenden Kilometer
     * @param ziel Das Zielort
     */
    void fahren(int km, String ziel) {
        System.out.println("Fahre nach " + ziel + " (" + km + " km)...");
        fahren(km);  // Ruft die andere fahren()-Methode auf
    }
    
    /**
     * Das Auto fährt zu einem Ziel (nur Zielname).
     * Version 4: Nur Ziel
     * 
     * @param ziel Das Ziel
     */
    void fahren(String ziel) {
        System.out.println("Fahre nach " + ziel + " (Entfernung unbekannt)");
    }
    
    
    // ========================================
    // WEITERE METHODEN
    // ========================================
    
    /**
     * Tankt das Auto auf.
     * 
     * @param liter Die zu tankenden Liter
     */
    void tanken(double liter) {
        tankinhalt = tankinhalt + liter;
        System.out.println("Getankt: " + liter + " Liter. Tank jetzt: " + 
            String.format("%.1f", tankinhalt) + " L");
    }
    
    /**
     * Berechnet die Reichweite mit aktuellem Tankinhalt.
     * 
     * @return Die Reichweite in Kilometern
     */
    double berechneReichweite() {
        return (tankinhalt / verbrauch) * 100;
    }
    
    /**
     * Gibt alle Informationen über das Auto aus.
     */
    void info() {
        System.out.println("╔═══════════════════════════════╗");
        System.out.println("║       AUTO-INFORMATION        ║");
        System.out.println("╠═══════════════════════════════╣");
        System.out.println("║ Marke:        " + padRight(marke, 16) + "║");
        System.out.println("║ Farbe:        " + padRight(farbe, 16) + "║");
        System.out.println("║ Leistung:     " + padRight(ps + " PS", 16) + "║");
        System.out.println("║ Kilometerstand: " + padRight(kilometerstand + " km", 14) + "║");
        System.out.println("║ Tankinhalt:   " + padRight(String.format("%.1f L", tankinhalt), 16) + "║");
        System.out.println("║ Reichweite:   " + padRight(String.format("%.0f km", berechneReichweite()), 16) + "║");
        System.out.println("╚═══════════════════════════════╝");
    }
    
    /**
     * Hilfsmethode zum Auffüllen von Strings (für formatierte Ausgabe).
     */
    private String padRight(String s, int length) {
        if (s == null) s = "null";
        return String.format("%-" + length + "s", s);
    }
}
