# Java OOP - Tag 3: Datenkapselung & Sichtbarkeit

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 3 von 10  
**Thema:** Sichtbarkeitsmodifier, Kapselung, Getter/Setter, Validierung  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

### Voraussetzungen

- **Java 21** (Amazon Corretto empfohlen)
- **Maven 3.8+**

### Projekt ausführen

```bash
cd Tag03_Datenkapselung
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag03_Datenkapselung/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java                # Vergleich & Demos
        └── model/
            ├── Auto.java            # ✅ Gekapselt (richtig!)
            └── AutoUnsafe.java      # ❌ Ungekapselt (zum Vergleich)
```

---

## 📝 Was dieses Projekt demonstriert

### Das Problem (AutoUnsafe.java)
```java
public String farbe;   // Jeder kann alles setzen!
public int ps;         // Auch negative Werte!
```

### Die Lösung (Auto.java)
```java
private int ps;

public void setPs(int ps) {
    if (ps < 1 || ps > 2000) {
        throw new IllegalArgumentException("PS ungültig!");
    }
    this.ps = ps;
}
```

---

## 🎯 Lernziele

Nach diesem Tag kannst du:

- ✅ Die 4 Sichtbarkeitsmodifier erklären (public, protected, default, private)
- ✅ Attribute kapseln (private + Getter/Setter)
- ✅ Validierung in Settern implementieren
- ✅ Kontrollierte Zustandsänderungen erzwingen
- ✅ Die JavaBeans-Konvention anwenden

---

## 🔗 Weiterführende Links

- [Tag 3 Blogpost](https://java-developer.online/kurse/java-oop/tag-3)
- [Oracle — Access Control](https://docs.oracle.com/javase/tutorial/java/javaOO/accesscontrol.html)

---

## 💬 Fragen?

Schreib uns: **nova@java-developer.online**

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
