package de.javafleet.oop;

import de.javafleet.oop.model.Auto;
import de.javafleet.oop.model.AutoUnsafe;

/**
 * Einstiegspunkt für Tag 3: Datenkapselung & Sichtbarkeit.
 * 
 * Demonstriert:
 * - Unterschied zwischen gekapselten und ungekapselten Klassen
 * - Validierung in Settern
 * - Kontrollierte Zustandsänderungen
 * - Fehlermeldungen bei ungültigen Werten
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║   Java OOP - Tag 3: Datenkapselung & Sichtbarkeit ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // TEIL 1: DAS PROBLEM - Ungekapselte Klasse
        // ========================================
        
        System.out.println("═══ TEIL 1: Das Problem (AutoUnsafe) ═══");
        System.out.println();
        
        AutoUnsafe unsafeAuto = new AutoUnsafe();
        
        // Alles geht - auch Unsinn!
        unsafeAuto.marke = "VW";
        unsafeAuto.farbe = "Rot";
        unsafeAuto.ps = 150;
        unsafeAuto.kilometerstand = 50000;
        unsafeAuto.tankinhalt = 40;
        
        System.out.println(">>> Normaler Zustand:");
        unsafeAuto.info();
        
        // Aber auch das geht:
        System.out.println(">>> Und jetzt der Unsinn (direkte Zuweisung):");
        unsafeAuto.ps = -500;           // Negative PS?!
        unsafeAuto.kilometerstand = -1; // Negativer Kilometerstand?!
        unsafeAuto.tankinhalt = 999999; // Unrealistisch!
        unsafeAuto.farbe = null;        // Keine Farbe?!
        
        unsafeAuto.info();
        System.out.println("😱 Alle unsinnigen Werte wurden akzeptiert!");
        System.out.println();
        
        // ========================================
        // TEIL 2: DIE LÖSUNG - Gekapselte Klasse
        // ========================================
        
        System.out.println("═══ TEIL 2: Die Lösung (Auto gekapselt) ═══");
        System.out.println();
        
        Auto auto = new Auto();
        
        // Setter mit Validierung
        auto.setMarke("BMW");
        auto.setFarbe("Blau");
        auto.setPs(200);
        
        System.out.println(">>> Initialisiert mit Settern:");
        auto.info();
        System.out.println();
        
        // ========================================
        // TEIL 3: Validierung in Aktion
        // ========================================
        
        System.out.println("═══ TEIL 3: Validierung in Aktion ═══");
        System.out.println();
        
        // Versuche ungültige Werte zu setzen
        System.out.println(">>> Versuche negative PS zu setzen...");
        try {
            auto.setPs(-100);
        } catch (IllegalArgumentException e) {
            System.out.println("❌ Abgelehnt: " + e.getMessage());
        }
        
        System.out.println();
        System.out.println(">>> Versuche leere Farbe zu setzen...");
        try {
            auto.setFarbe("");
        } catch (IllegalArgumentException e) {
            System.out.println("❌ Abgelehnt: " + e.getMessage());
        }
        
        System.out.println();
        System.out.println(">>> Versuche zu fahren ohne Motor...");
        try {
            auto.fahren(100);
        } catch (IllegalStateException e) {
            System.out.println("❌ Abgelehnt: " + e.getMessage());
        }
        
        System.out.println();
        
        // ========================================
        // TEIL 4: Richtige Nutzung
        // ========================================
        
        System.out.println("═══ TEIL 4: Richtige Nutzung ═══");
        System.out.println();
        
        // Tanken
        auto.tanken(45);
        
        // Motor starten
        auto.starteMotor();
        
        // Fahren
        auto.fahren(50);
        auto.fahren(100);
        
        // Motor stoppen
        auto.stoppeMotor();
        
        System.out.println();
        System.out.println(">>> Finaler Zustand:");
        auto.info();
        
        System.out.println();
        
        // ========================================
        // TEIL 5: Tank-Überlauf (Validierung)
        // ========================================
        
        System.out.println("═══ TEIL 5: Tank-Überlauf-Schutz ═══");
        System.out.println();
        
        System.out.println(">>> Versuche 100 Liter zu tanken (Tank ist 50L groß)...");
        auto.tanken(100);  // Wird nur bis zur Kapazität gefüllt!
        
        System.out.println();
        System.out.println("✅ Tag 3 geschafft!");
        System.out.println();
        
        // ========================================
        // AUFGABE
        // ========================================
        
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║                  DEINE AUFGABE                    ║");
        System.out.println("╠═══════════════════════════════════════════════════╣");
        System.out.println("║ Erstelle eine gekapselte Klasse 'Bankkonto':      ║");
        System.out.println("║                                                   ║");
        System.out.println("║ - kontonummer (String) → nur Getter, kein Setter  ║");
        System.out.println("║ - kontostand (double) → startet bei 0             ║");
        System.out.println("║ - pin (String) → 4 Ziffern, nur intern            ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Methoden:                                         ║");
        System.out.println("║ - einzahlen(double) → nur positive Beträge        ║");
        System.out.println("║ - abheben(double, String pin) → prüft PIN         ║");
        System.out.println("║ - pinAendern(String alt, String neu)              ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Lösung: Anfang Tag 4!                             ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
    }
}
