# Java OOP - Tag 4: Konstruktoren

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 4 von 10  
**Thema:** Konstruktoren, Überladung, Verkettung, Validierung  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

### Voraussetzungen

- **Java 21** (Amazon Corretto empfohlen)
- **Maven 3.8+**

### Projekt ausführen

```bash
cd Tag04_Konstruktoren
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag04_Konstruktoren/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java              # Demo aller Konstruktor-Konzepte
        └── model/
            ├── Auto.java          # Konstruktor-Verkettung, Copy-Konstruktor
            └── Bankkonto.java     # Lösung Tag 3 Challenge
```

---

## 📝 Was dieses Projekt demonstriert

### Konstruktorüberladung
```java
public Auto(String fgnr, String farbe, int ps, String marke) { }
public Auto(String fgnr, String farbe, int ps) { }
public Auto(String fgnr) { }
```

### Konstruktorverkettung mit this()
```java
public Auto(String fgnr, String farbe, int ps) {
    this(fgnr, farbe, ps, "Unbekannt");  // Ruft Hauptkonstruktor
}
```

### Validierung im Konstruktor
```java
if (ps < 1 || ps > 2000) {
    throw new IllegalArgumentException("PS ungültig!");
}
```

### Copy-Konstruktor
```java
public Auto(Auto original) {
    this(original.fgnr + "-COPY", original.farbe, ...);
}
```

---

## 🎯 Lernziele

Nach diesem Tag kannst du:

- ✅ Konstruktoren definieren und überladen
- ✅ Konstruktorverkettung mit this() einsetzen
- ✅ Validierung im Konstruktor implementieren
- ✅ final-Attribute initialisieren
- ✅ Copy-Konstruktoren schreiben

---

## 🔗 Weiterführende Links

- [Tag 4 Blogpost](https://java-developer.online/kurse/java-oop/tag-4)
- [Oracle — Constructors](https://docs.oracle.com/javase/tutorial/java/javaOO/constructors.html)

---

## 💬 Fragen?

Schreib uns: **nova@java-developer.online**

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
