package de.javafleet.oop;

import de.javafleet.oop.model.Auto;
import de.javafleet.oop.model.Bankkonto;

/**
 * Einstiegspunkt für Tag 4: Konstruktoren.
 * 
 * Demonstriert:
 * - Konstruktorüberladung
 * - Konstruktorverkettung mit this()
 * - Validierung im Konstruktor
 * - Copy-Konstruktor
 * - final-Attribute
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════════════╗");
        System.out.println("║       Java OOP - Tag 4: Konstruktoren         ║");
        System.out.println("╚═══════════════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // TEIL 1: Konstruktorüberladung
        // ========================================
        
        System.out.println("═══ TEIL 1: Konstruktorüberladung ═══");
        System.out.println();
        
        System.out.println(">>> Konstruktor mit allen Parametern:");
        Auto auto1 = new Auto("WVW123456789ABCDE", "Rot", 150, "VW Golf");
        
        System.out.println();
        System.out.println(">>> Konstruktor ohne Marke (Default: 'Unbekannt'):");
        Auto auto2 = new Auto("BMW999888777666AB", "Blau", 200);
        
        System.out.println();
        System.out.println(">>> Konstruktor nur mit Fahrgestellnummer (alle Defaults):");
        Auto auto3 = new Auto("AUD111222333444CD");
        
        System.out.println();
        
        // ========================================
        // TEIL 2: Konstruktor-Verkettung
        // ========================================
        
        System.out.println("═══ TEIL 2: Konstruktor-Verkettung ═══");
        System.out.println();
        System.out.println("Alle Konstruktoren nutzen denselben Hauptkonstruktor!");
        System.out.println("→ Validierung an nur EINER Stelle");
        System.out.println("→ Kein doppelter Code");
        System.out.println();
        
        auto1.info();
        auto2.info();
        auto3.info();
        
        System.out.println();
        
        // ========================================
        // TEIL 3: Copy-Konstruktor
        // ========================================
        
        System.out.println("═══ TEIL 3: Copy-Konstruktor ═══");
        System.out.println();
        
        System.out.println(">>> Original Auto:");
        auto1.fahren(5000);
        auto1.info();
        
        System.out.println();
        System.out.println(">>> Kopie erstellen:");
        Auto kopie = new Auto(auto1);
        kopie.info();
        
        System.out.println();
        System.out.println(">>> Original ändern (Kopie bleibt unverändert):");
        auto1.fahren(10000);
        System.out.println("Original KM: " + auto1.getKilometerstand());
        System.out.println("Kopie KM:    " + kopie.getKilometerstand());
        
        System.out.println();
        
        // ========================================
        // TEIL 4: Validierung im Konstruktor
        // ========================================
        
        System.out.println("═══ TEIL 4: Validierung im Konstruktor ═══");
        System.out.println();
        
        System.out.println(">>> Versuche Auto mit ungültiger Fahrgestellnummer:");
        try {
            new Auto("ABC", "Rot", 150, "Test");  // Zu kurz!
        } catch (IllegalArgumentException e) {
            System.out.println("❌ Abgelehnt: " + e.getMessage());
        }
        
        System.out.println();
        System.out.println(">>> Versuche Auto mit negativen PS:");
        try {
            new Auto("12345678901234567", "Rot", -50, "Test");
        } catch (IllegalArgumentException e) {
            System.out.println("❌ Abgelehnt: " + e.getMessage());
        }
        
        System.out.println();
        System.out.println(">>> Versuche Auto mit leerer Farbe:");
        try {
            new Auto("12345678901234567", "", 150, "Test");
        } catch (IllegalArgumentException e) {
            System.out.println("❌ Abgelehnt: " + e.getMessage());
        }
        
        System.out.println();
        
        // ========================================
        // TEIL 5: Bankkonto (Lösung Tag 3)
        // ========================================
        
        System.out.println("═══ TEIL 5: Bankkonto (Lösung Tag 3 Challenge) ═══");
        System.out.println();
        
        System.out.println(">>> Konto eröffnen:");
        Bankkonto konto = new Bankkonto("DE89370400440532013000", "1234", 1000);
        konto.info();
        
        System.out.println();
        System.out.println(">>> Einzahlen:");
        konto.einzahlen(500);
        
        System.out.println();
        System.out.println(">>> Abheben mit korrekter PIN:");
        konto.abheben(200, "1234");
        
        System.out.println();
        System.out.println(">>> Abheben mit falscher PIN:");
        try {
            konto.abheben(100, "0000");
        } catch (SecurityException e) {
            System.out.println("❌ " + e.getMessage());
        }
        
        System.out.println();
        System.out.println(">>> PIN ändern:");
        konto.pinAendern("1234", "5678");
        
        System.out.println();
        System.out.println(">>> Abheben mit neuer PIN:");
        konto.abheben(50, "5678");
        
        System.out.println();
        konto.info();
        
        System.out.println();
        System.out.println("✅ Tag 4 geschafft!");
        System.out.println();
        
        // ========================================
        // AUFGABE
        // ========================================
        
        System.out.println("╔═══════════════════════════════════════════════╗");
        System.out.println("║                  DEINE AUFGABE                ║");
        System.out.println("╠═══════════════════════════════════════════════╣");
        System.out.println("║ Erstelle eine 'Mitarbeiter'-Klasse:           ║");
        System.out.println("║                                               ║");
        System.out.println("║ Attribute:                                    ║");
        System.out.println("║ - personalnummer (final String, z.B. 'P1234') ║");
        System.out.println("║ - name (String)                               ║");
        System.out.println("║ - abteilung (String)                          ║");
        System.out.println("║ - gehalt (double, min 1500€)                  ║");
        System.out.println("║                                               ║");
        System.out.println("║ 3 Konstruktoren mit Verkettung:               ║");
        System.out.println("║ - (pnr, name, abteilung, gehalt) → Haupt      ║");
        System.out.println("║ - (pnr, name, abteilung) → gehalt=3000        ║");
        System.out.println("║ - (pnr, name) → abteilung='Allgemein'         ║");
        System.out.println("║                                               ║");
        System.out.println("║ Lösung: Anfang Tag 5!                         ║");
        System.out.println("╚═══════════════════════════════════════════════╝");
    }
}
