# Java OOP - Tag 5: Static & Konstanten 🔴 KOPFNUSS

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 5 von 10 (KOPFNUSS!)  
**Thema:** static, final, static final, Utility-Klassen  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

### Voraussetzungen

- **Java 21** (Amazon Corretto empfohlen)
- **Maven 3.8+**

### Projekt ausführen

```bash
cd Tag05_Static_Konstanten
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag05_Static_Konstanten/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java
        ├── model/
        │   ├── Auto.java           # Static Zähler + Konstanten
        │   └── Mitarbeiter.java    # Lösung Tag 4
        └── util/
            ├── MathUtils.java      # Utility-Klasse
            └── GameSettings.java   # Nur Konstanten
```

---

## 📝 Was dieses Projekt demonstriert

### Static Klassenvariable
```java
private static int anzahlAutos = 0;

public static int getAnzahlAutos() {
    return anzahlAutos;
}
```

### Static final Konstanten
```java
public static final int MAX_PS = 2000;
public static final String VERSION = "1.0.0";
```

### Utility-Klasse
```java
public final class MathUtils {
    private MathUtils() { }  // Keine Instanzen!
    
    public static int addiere(int a, int b) {
        return a + b;
    }
}
```

---

## 🎯 Lernziele

Nach diesem Tag kannst du:

- ✅ static für Klassenvariablen einsetzen
- ✅ static für Methoden verwenden
- ✅ Konstanten mit static final definieren
- ✅ Utility-Klassen korrekt aufbauen
- ✅ Die Einschränkungen von static verstehen

---

## 🔗 Weiterführende Links

- [Tag 5 Blogpost](https://java-developer.online/kurse/java-oop/tag-5)
- [Oracle — Static Members](https://docs.oracle.com/javase/tutorial/java/javaOO/classvars.html)

---

## 💬 Fragen?

Schreib uns: **nova@java-developer.online**

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
