package de.javafleet.oop;

import de.javafleet.oop.model.Auto;
import de.javafleet.oop.model.Mitarbeiter;
import de.javafleet.oop.util.MathUtils;
import de.javafleet.oop.util.GameSettings;

/**
 * Einstiegspunkt für Tag 5: Static & Konstanten (KOPFNUSS).
 * 
 * Demonstriert:
 * - Static Klassenvariablen
 * - Static Methoden
 * - Static final Konstanten
 * - Utility-Klassen
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║   Java OOP - Tag 5: Static & Konstanten 🔴        ║");
        System.out.println("║                    KOPFNUSS                       ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // TEIL 1: Static Klassenvariable (Zähler)
        // ========================================
        
        System.out.println("═══ TEIL 1: Static Klassenvariable (Zähler) ═══");
        System.out.println();
        
        System.out.println("Anzahl Autos VOR Erstellung: " + Auto.getAnzahlAutos());
        System.out.println();
        
        Auto auto1 = new Auto("Rot", 150, "VW Golf");
        Auto auto2 = new Auto("Blau", 200, "BMW");
        Auto auto3 = new Auto("Grün", 180, "Audi");
        
        System.out.println();
        System.out.println("Anzahl Autos NACH Erstellung: " + Auto.getAnzahlAutos());
        System.out.println();
        
        System.out.println("Auto-Nummern:");
        System.out.println("  auto1: #" + auto1.getAutoNummer());
        System.out.println("  auto2: #" + auto2.getAutoNummer());
        System.out.println("  auto3: #" + auto3.getAutoNummer());
        
        System.out.println();
        
        // ========================================
        // TEIL 2: Static Konstanten
        // ========================================
        
        System.out.println("═══ TEIL 2: Static Konstanten ═══");
        System.out.println();
        
        System.out.println("Auto-Konstanten:");
        System.out.println("  MAX_PS:        " + Auto.MAX_PS);
        System.out.println("  MIN_PS:        " + Auto.MIN_PS);
        System.out.println("  DEFAULT_FARBE: " + Auto.DEFAULT_FARBE);
        
        System.out.println();
        
        System.out.println("GameSettings-Konstanten:");
        System.out.println("  MAX_PLAYERS:   " + GameSettings.MAX_PLAYERS);
        System.out.println("  MAX_LEVEL:     " + GameSettings.MAX_LEVEL);
        System.out.println("  GRAVITY:       " + GameSettings.GRAVITY);
        System.out.println("  VERSION:       " + GameSettings.VERSION);
        
        System.out.println();
        
        System.out.println("MathUtils-Konstanten:");
        System.out.println("  PI:            " + MathUtils.PI);
        System.out.println("  E:             " + MathUtils.E);
        System.out.println("  GOLDEN_RATIO:  " + MathUtils.GOLDEN_RATIO);
        
        System.out.println();
        
        // ========================================
        // TEIL 3: Static Methoden (Utility)
        // ========================================
        
        System.out.println("═══ TEIL 3: Static Methoden (Utility) ═══");
        System.out.println();
        
        System.out.println("MathUtils-Berechnungen:");
        System.out.println("  5 + 3 = " + MathUtils.addiere(5, 3));
        System.out.println("  4 * 7 = " + MathUtils.multipliziere(4, 7));
        System.out.println("  5! = " + MathUtils.fakultaet(5));
        System.out.println("  GGT(48, 18) = " + MathUtils.ggt(48, 18));
        System.out.println("  Kreisfläche (r=5) = " + String.format("%.2f", MathUtils.kreisflaeche(5)));
        System.out.println("  20°C in Fahrenheit = " + String.format("%.1f", MathUtils.celsiusZuFahrenheit(20)));
        
        System.out.println();
        
        System.out.println("Primzahltest:");
        int[] zahlen = {2, 7, 10, 13, 17, 20, 23};
        for (int z : zahlen) {
            System.out.println("  " + z + " ist Primzahl: " + MathUtils.istPrimzahl(z));
        }
        
        System.out.println();
        
        // ========================================
        // TEIL 4: Static Methode der Auto-Klasse
        // ========================================
        
        System.out.println("═══ TEIL 4: Static Validierung ═══");
        System.out.println();
        
        System.out.println("PS-Validierung:");
        System.out.println("  150 PS gültig: " + Auto.istGueltigePS(150));
        System.out.println("  2500 PS gültig: " + Auto.istGueltigePS(2500));
        System.out.println("  -50 PS gültig: " + Auto.istGueltigePS(-50));
        
        System.out.println();
        
        // ========================================
        // TEIL 5: Lösung Tag 4 (Mitarbeiter)
        // ========================================
        
        System.out.println("═══ TEIL 5: Mitarbeiter (Lösung Tag 4) ═══");
        System.out.println();
        
        Mitarbeiter m1 = new Mitarbeiter("P1234", "Max Mustermann", "IT", 4500);
        Mitarbeiter m2 = new Mitarbeiter("P5678", "Anna Schmidt", "HR");
        Mitarbeiter m3 = new Mitarbeiter("P9999", "Tom Fischer");
        
        System.out.println();
        m1.info();
        m2.info();
        m3.info();
        
        System.out.println();
        System.out.println("Mitarbeiter-Konstanten:");
        System.out.println("  MINDEST_GEHALT:    " + Mitarbeiter.MINDEST_GEHALT + " €");
        System.out.println("  DEFAULT_GEHALT:    " + Mitarbeiter.DEFAULT_GEHALT + " €");
        System.out.println("  DEFAULT_ABTEILUNG: " + Mitarbeiter.DEFAULT_ABTEILUNG);
        
        System.out.println();
        System.out.println("✅ Tag 5 (KOPFNUSS) geschafft!");
        System.out.println();
        
        // ========================================
        // AUFGABE
        // ========================================
        
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║                  DEINE AUFGABE                    ║");
        System.out.println("╠═══════════════════════════════════════════════════╣");
        System.out.println("║ Erstelle eine 'Konto'-Klasse mit:                 ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Static Konstanten:                                ║");
        System.out.println("║ - MINDEST_EINLAGE = 100.0                         ║");
        System.out.println("║ - MAX_TAGESABHEBUNG = 1000.0                      ║");
        System.out.println("║ - IBAN_PREFIX = \"DE\"                              ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Static Variable:                                  ║");
        System.out.println("║ - anzahlKonten (Zähler)                           ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Static Methoden:                                  ║");
        System.out.println("║ - getAnzahlKonten()                               ║");
        System.out.println("║ - generiereIBAN() → IBAN_PREFIX + anzahlKonten    ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Lösung: Anfang Tag 6!                             ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
    }
}
