package de.javafleet.oop.util;

/**
 * Beispiel für eine Konstanten-Klasse.
 * 
 * Enthält nur static final Konstanten für Spieleinstellungen.
 * 
 * @author Nova Trent
 * @version 1.0
 */
public final class GameSettings {
    
    // ========================================
    // PRIVATER KONSTRUKTOR
    // ========================================
    
    private GameSettings() {
        throw new AssertionError("Konstanten-Klasse: Keine Instanzen erlaubt!");
    }
    
    // ========================================
    // SPIELER-EINSTELLUNGEN
    // ========================================
    
    /** Maximale Anzahl Spieler pro Spiel */
    public static final int MAX_PLAYERS = 4;
    
    /** Minimale Anzahl Spieler pro Spiel */
    public static final int MIN_PLAYERS = 1;
    
    /** Standard-Spielername */
    public static final String DEFAULT_PLAYER_NAME = "Spieler";
    
    /** Startleben für neue Spieler */
    public static final int START_LIVES = 3;
    
    // ========================================
    // LEVEL-EINSTELLUNGEN
    // ========================================
    
    /** Erstes Level */
    public static final int MIN_LEVEL = 1;
    
    /** Höchstes Level */
    public static final int MAX_LEVEL = 100;
    
    /** XP für Level-Up */
    public static final int XP_PER_LEVEL = 1000;
    
    // ========================================
    // PHYSIK-KONSTANTEN
    // ========================================
    
    /** Schwerkraft (Einheiten pro Sekunde²) */
    public static final double GRAVITY = 9.81;
    
    /** Maximale Geschwindigkeit */
    public static final double MAX_SPEED = 50.0;
    
    /** Reibungskoeffizient */
    public static final double FRICTION = 0.8;
    
    // ========================================
    // SPIEL-TIMING
    // ========================================
    
    /** Frames pro Sekunde */
    public static final int FPS = 60;
    
    /** Millisekunden pro Frame */
    public static final double MS_PER_FRAME = 1000.0 / FPS;
    
    /** Timeout für Spieler-Inaktivität (Sekunden) */
    public static final int IDLE_TIMEOUT_SECONDS = 300;
    
    // ========================================
    // VERSION
    // ========================================
    
    /** Spielversion */
    public static final String VERSION = "1.0.0";
    
    /** Build-Nummer */
    public static final int BUILD_NUMBER = 42;
    
    /** Release-Datum */
    public static final String RELEASE_DATE = "2025-01-01";
}
