package de.javafleet.oop.util;

/**
 * Utility-Klasse für mathematische Berechnungen.
 * 
 * Demonstriert:
 * - Nur static Methoden
 * - Privater Konstruktor (keine Instanzen)
 * - final Klasse (keine Vererbung)
 * 
 * @author Nova Trent
 * @version 1.0
 */
public final class MathUtils {
    
    // ========================================
    // KONSTANTEN
    // ========================================
    
    /** Kreiszahl Pi */
    public static final double PI = 3.14159265358979323846;
    
    /** Eulersche Zahl */
    public static final double E = 2.71828182845904523536;
    
    /** Goldener Schnitt */
    public static final double GOLDEN_RATIO = 1.61803398874989484820;
    
    // ========================================
    // PRIVATER KONSTRUKTOR
    // ========================================
    
    /**
     * Privater Konstruktor — keine Instanzen erlaubt!
     */
    private MathUtils() {
        throw new AssertionError("Utility-Klasse: Keine Instanzen erlaubt!");
    }
    
    // ========================================
    // STATIC METHODEN
    // ========================================
    
    /**
     * Addiert zwei Zahlen.
     */
    public static int addiere(int a, int b) {
        return a + b;
    }
    
    /**
     * Multipliziert zwei Zahlen.
     */
    public static int multipliziere(int a, int b) {
        return a * b;
    }
    
    /**
     * Berechnet die Fakultät einer Zahl.
     * 
     * @param n Eine nicht-negative Zahl
     * @return n! (n Fakultät)
     */
    public static long fakultaet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Fakultät ist für negative Zahlen nicht definiert!");
        }
        if (n <= 1) {
            return 1;
        }
        long result = 1;
        for (int i = 2; i <= n; i++) {
            result *= i;
        }
        return result;
    }
    
    /**
     * Prüft, ob eine Zahl eine Primzahl ist.
     */
    public static boolean istPrimzahl(int n) {
        if (n < 2) return false;
        if (n == 2) return true;
        if (n % 2 == 0) return false;
        
        for (int i = 3; i <= Math.sqrt(n); i += 2) {
            if (n % i == 0) return false;
        }
        return true;
    }
    
    /**
     * Berechnet den größten gemeinsamen Teiler (GGT).
     */
    public static int ggt(int a, int b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            int temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }
    
    /**
     * Berechnet die Kreisfläche.
     */
    public static double kreisflaeche(double radius) {
        if (radius < 0) {
            throw new IllegalArgumentException("Radius darf nicht negativ sein!");
        }
        return PI * radius * radius;
    }
    
    /**
     * Berechnet den Kreisumfang.
     */
    public static double kreisumfang(double radius) {
        if (radius < 0) {
            throw new IllegalArgumentException("Radius darf nicht negativ sein!");
        }
        return 2 * PI * radius;
    }
    
    /**
     * Konvertiert Celsius zu Fahrenheit.
     */
    public static double celsiusZuFahrenheit(double celsius) {
        return celsius * 9.0 / 5.0 + 32;
    }
    
    /**
     * Konvertiert Fahrenheit zu Celsius.
     */
    public static double fahrenheitZuCelsius(double fahrenheit) {
        return (fahrenheit - 32) * 5.0 / 9.0;
    }
}
