# Java OOP - Tag 6: Vererbung Grundlagen

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 6 von 10  
**Thema:** Vererbung, extends, super(), protected  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

### Voraussetzungen

- **Java 21** (Amazon Corretto empfohlen)
- **Maven 3.8+**

### Projekt ausführen

```bash
cd Tag06_Vererbung
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag06_Vererbung/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java
        └── model/
            ├── Fahrzeug.java       (Elternklasse)
            ├── Auto.java           (extends Fahrzeug)
            ├── Motorrad.java       (extends Fahrzeug)
            └── Konto.java          (Lösung Tag 5)
```

---

## 📝 Was dieses Projekt demonstriert

### Vererbung mit extends
```java
public class Auto extends Fahrzeug {
    // Auto erbt alle public/protected Member von Fahrzeug
}
```

### super() Konstruktoraufruf
```java
public Auto(String marke, int baujahr) {
    super(marke, baujahr);  // Ruft Fahrzeug-Konstruktor
    this.anzahlTueren = 4;
}
```

### protected Sichtbarkeit
```java
// In Fahrzeug:
protected String marke;  // Für Kindklassen zugänglich

// In Auto:
System.out.println(marke);  // ✅ Zugriff erlaubt!
```

---

## 🎯 Lernziele

Nach diesem Tag kannst du:

- ✅ Vererbung mit extends einsetzen
- ✅ Konstruktoren mit super() verketten
- ✅ protected vs. private verstehen
- ✅ Methoden überschreiben (@Override)
- ✅ IS-A Beziehungen erkennen

---

## 🔗 Weiterführende Links

- [Tag 6 Blogpost](https://java-developer.online/kurse/java-oop/tag-6)
- [Oracle — Inheritance](https://docs.oracle.com/javase/tutorial/java/IandI/subclasses.html)

---

## 💬 Fragen?

Schreib uns: **nova@java-developer.online**

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
