package de.javafleet.oop;

import de.javafleet.oop.model.Fahrzeug;
import de.javafleet.oop.model.Auto;
import de.javafleet.oop.model.Motorrad;
import de.javafleet.oop.model.Konto;

/**
 * Einstiegspunkt für Tag 6: Vererbung Grundlagen.
 * 
 * Demonstriert:
 * - extends für Vererbung
 * - super() Konstruktoraufruf
 * - Geerbte Methoden
 * - protected Sichtbarkeit
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║     Java OOP - Tag 6: Vererbung Grundlagen        ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // TEIL 1: Vererbungshierarchie
        // ========================================
        
        System.out.println("═══ TEIL 1: Vererbungshierarchie ═══");
        System.out.println();
        
        System.out.println(">>> Fahrzeug (Elternklasse):");
        Fahrzeug fahrzeug = new Fahrzeug("Generic", 2020);
        fahrzeug.info();
        fahrzeug.fahren(100);
        
        System.out.println();
        
        System.out.println(">>> Auto (extends Fahrzeug):");
        Auto auto = new Auto("VW Golf", 2024, 4);
        auto.info();
        auto.fahren(50);  // Geerbt von Fahrzeug!
        auto.hupen();     // Eigene Methode
        
        System.out.println();
        
        System.out.println(">>> Motorrad (extends Fahrzeug):");
        Motorrad motorrad = new Motorrad("Harley Davidson", 2023, 1200, "Chopper");
        motorrad.info();
        motorrad.fahren(50);  // Geerbt von Fahrzeug!
        motorrad.wheelie();   // Eigene Methode
        
        System.out.println();
        
        // ========================================
        // TEIL 2: Geerbte Methoden
        // ========================================
        
        System.out.println("═══ TEIL 2: Geerbte Methoden ═══");
        System.out.println();
        
        System.out.println("Alle Fahrzeuge können fahren():");
        System.out.print("  Fahrzeug: ");
        fahrzeug.fahren(10);
        System.out.print("  Auto:     ");
        auto.fahren(10);
        System.out.print("  Motorrad: ");
        motorrad.fahren(10);
        
        System.out.println();
        
        System.out.println("Alle haben getMarke() geerbt:");
        System.out.println("  Fahrzeug-Marke: " + fahrzeug.getMarke());
        System.out.println("  Auto-Marke:     " + auto.getMarke());
        System.out.println("  Motorrad-Marke: " + motorrad.getMarke());
        
        System.out.println();
        
        // ========================================
        // TEIL 3: Spezifische Methoden
        // ========================================
        
        System.out.println("═══ TEIL 3: Spezifische Methoden ═══");
        System.out.println();
        
        System.out.println("Auto-spezifisch:");
        auto.hupen();
        System.out.println("  Türen: " + auto.getAnzahlTueren());
        
        System.out.println();
        
        System.out.println("Motorrad-spezifisch:");
        motorrad.wheelie();
        System.out.println("  Hubraum: " + motorrad.getHubraum() + " ccm");
        
        System.out.println();
        
        // ========================================
        // TEIL 4: IS-A Beziehung
        // ========================================
        
        System.out.println("═══ TEIL 4: IS-A Beziehung ═══");
        System.out.println();
        
        System.out.println("Ein Auto IST ein Fahrzeug:");
        System.out.println("  auto instanceof Fahrzeug: " + (auto instanceof Fahrzeug));
        System.out.println("  auto instanceof Auto:     " + (auto instanceof Auto));
        
        System.out.println();
        
        System.out.println("Ein Motorrad IST ein Fahrzeug:");
        System.out.println("  motorrad instanceof Fahrzeug: " + (motorrad instanceof Fahrzeug));
        System.out.println("  motorrad instanceof Motorrad: " + (motorrad instanceof Motorrad));
        
        System.out.println();
        
        // ========================================
        // TEIL 5: Konto (Lösung Tag 5)
        // ========================================
        
        System.out.println("═══ TEIL 5: Konto (Lösung Tag 5) ═══");
        System.out.println();
        
        System.out.println("Konstanten:");
        System.out.println("  MINDEST_EINLAGE:    " + Konto.MINDEST_EINLAGE + "€");
        System.out.println("  MAX_TAGESABHEBUNG:  " + Konto.MAX_TAGESABHEBUNG + "€");
        System.out.println("  IBAN_PREFIX:        " + Konto.IBAN_PREFIX);
        
        System.out.println();
        
        Konto konto1 = new Konto(500);
        Konto konto2 = new Konto(1000);
        
        System.out.println();
        System.out.println("Anzahl Konten: " + Konto.getAnzahlKonten());
        
        System.out.println();
        konto1.einzahlen(200);
        konto1.abheben(150);
        konto1.info();
        
        System.out.println();
        System.out.println("✅ Tag 6 geschafft!");
        System.out.println();
        
        // ========================================
        // AUFGABE
        // ========================================
        
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║                  DEINE AUFGABE                    ║");
        System.out.println("╠═══════════════════════════════════════════════════╣");
        System.out.println("║ Erstelle eine Mitarbeiter-Hierarchie:             ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Elternklasse Mitarbeiter:                         ║");
        System.out.println("║ - name, personalnummer, gehalt                    ║");
        System.out.println("║ - arbeiten(), getJahresgehalt()                   ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Kindklasse Entwickler:                            ║");
        System.out.println("║ - programmiersprache                              ║");
        System.out.println("║ - @Override arbeiten(), coden()                   ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Kindklasse Manager:                               ║");
        System.out.println("║ - teamgroesse                                     ║");
        System.out.println("║ - @Override getJahresgehalt() +10%, meeting()     ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Lösung: Anfang Tag 7!                             ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
    }
}
