package de.javafleet.oop.model;

/**
 * Motorrad-Klasse — Kindklasse von Fahrzeug für Tag 6: Vererbung.
 * 
 * Demonstriert:
 * - Weitere Kindklasse der gleichen Elternklasse
 * - Unterschiedliche Attribute und Methoden
 * - Polymorphie-Vorbereitung (gleiche Elternklasse, anderes Verhalten)
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Motorrad extends Fahrzeug {
    
    // ========================================
    // ZUSÄTZLICHE ATTRIBUTE (nur für Motorrad)
    // ========================================
    
    /** Hubraum in ccm */
    private int hubraum;
    
    /** Hat das Motorrad einen Beiwagen? */
    private boolean hatBeiwagen;
    
    /** Typ des Motorrads */
    private String typ;  // z.B. "Chopper", "Sportler", "Enduro"
    
    // ========================================
    // KONSTRUKTOREN
    // ========================================
    
    /**
     * Erstellt ein neues Motorrad.
     * 
     * @param marke Die Marke
     * @param baujahr Das Baujahr
     * @param hubraum Der Hubraum in ccm
     * @param typ Der Motorradtyp
     * @param hatBeiwagen Hat es einen Beiwagen?
     */
    public Motorrad(String marke, int baujahr, int hubraum, String typ, boolean hatBeiwagen) {
        super(marke, baujahr);
        
        if (hubraum < 50 || hubraum > 2500) {
            throw new IllegalArgumentException("Hubraum muss zwischen 50 und 2500 ccm liegen!");
        }
        if (typ == null || typ.isBlank()) {
            throw new IllegalArgumentException("Typ darf nicht leer sein!");
        }
        
        this.hubraum = hubraum;
        this.typ = typ;
        this.hatBeiwagen = hatBeiwagen;
        
        System.out.println("  → Motorrad-Details: " + hubraum + " ccm, " + typ);
    }
    
    /**
     * Erstellt ein Motorrad ohne Beiwagen.
     */
    public Motorrad(String marke, int baujahr, int hubraum, String typ) {
        this(marke, baujahr, hubraum, typ, false);
    }
    
    /**
     * Erstellt ein Standard-Motorrad (Sportler, 600ccm).
     */
    public Motorrad(String marke, int baujahr) {
        this(marke, baujahr, 600, "Sportler", false);
    }
    
    // ========================================
    // EIGENE METHODEN (nur für Motorrad)
    // ========================================
    
    /**
     * Macht einen Wheelie!
     */
    public void wheelie() {
        if (hatBeiwagen) {
            System.out.println("🏍️ Mit Beiwagen geht kein Wheelie!");
        } else {
            System.out.println("🏍️ WHEEEEELIE! Das Vorderrad hebt ab!");
        }
    }
    
    /**
     * Drosselt das Motorrad auf die angegebene Leistung.
     * 
     * @param aufKw Die Ziel-Leistung in kW
     */
    public void drosseln(int aufKw) {
        System.out.println("Motorrad wird auf " + aufKw + " kW gedrosselt.");
    }
    
    /**
     * Prüft die Helmpflicht.
     */
    public void helmAufsetzen() {
        System.out.println("🪖 Helm aufgesetzt. Sicherheit geht vor!");
    }
    
    // ========================================
    // ÜBERSCHRIEBENE METHODEN
    // ========================================
    
    @Override
    public void fahren(int km) {
        super.fahren(km);
        System.out.println("  (Das Motorrad brüllt durch die Kurven!)");
    }
    
    @Override
    public void info() {
        System.out.println("╔════════════════════════════════════╗");
        System.out.println("║            MOTORRAD                ║");
        System.out.println("╠════════════════════════════════════╣");
        System.out.println("║ Marke:       " + pad(marke) + "║");
        System.out.println("║ Baujahr:     " + pad(String.valueOf(baujahr)) + "║");
        System.out.println("║ Kilometer:   " + pad(kilometerstand + " km") + "║");
        System.out.println("║ Hubraum:     " + pad(hubraum + " ccm") + "║");
        System.out.println("║ Typ:         " + pad(typ) + "║");
        System.out.println("║ Beiwagen:    " + pad(hatBeiwagen ? "Ja" : "Nein") + "║");
        System.out.println("╚════════════════════════════════════╝");
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public int getHubraum() {
        return hubraum;
    }
    
    public String getTyp() {
        return typ;
    }
    
    public boolean hatBeiwagen() {
        return hatBeiwagen;
    }
}
