# Java OOP - Tag 7: Polymorphie & Abstrakte Klassen

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 7 von 10  
**Thema:** Polymorphie, @Override, Abstrakte Klassen  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

```bash
cd Tag07_Polymorphie
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag07_Polymorphie/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java
        └── model/
            ├── Fahrzeug.java    (abstract)
            ├── Auto.java
            ├── Motorrad.java    (Lösung Tag 6)
            └── LKW.java
```

---

## 📝 Was dieses Projekt demonstriert

### Abstrakte Klasse
```java
public abstract class Fahrzeug {
    public abstract void fahren(int km);  // Kein Body!
    public void info() { ... }             // Mit Body
}
```

### Polymorphie
```java
Fahrzeug f;
f = new Auto(...);    f.fahren(10);  // → Auto-Verhalten
f = new Motorrad(...); f.fahren(10); // → Motorrad-Verhalten
f = new LKW(...);     f.fahren(10);  // → LKW-Verhalten
```

### @Override
```java
@Override
public void fahren(int km) {
    // Kind-spezifische Implementierung
}
```

---

## 🎯 Lernziele

- ✅ Polymorphie verstehen (eine Variable, viele Formen)
- ✅ @Override korrekt verwenden
- ✅ Abstrakte Klassen als Templates
- ✅ Abstrakte vs. normale Methoden unterscheiden

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
