package de.javafleet.oop;

import de.javafleet.oop.model.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Einstiegspunkt für Tag 7: Polymorphie & Abstrakte Klassen.
 * 
 * Demonstriert:
 * - Polymorphie (eine Variable, viele Formen)
 * - @Override (Methoden überschreiben)
 * - Abstrakte Klassen (Templates)
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║  Java OOP - Tag 7: Polymorphie & Abstrakte Klassen ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // TEIL 1: Abstrakte Klasse kann nicht instanziiert werden
        // ========================================
        
        System.out.println("═══ TEIL 1: Abstrakte Klasse ═══");
        System.out.println();
        
        // Das geht NICHT:
        // Fahrzeug f = new Fahrzeug("Test", 2024);  // ❌ Compilerfehler!
        
        System.out.println("Fahrzeug ist abstract — kann nicht instanziiert werden!");
        System.out.println("Nur konkrete Kindklassen wie Auto, Motorrad, LKW.");
        
        System.out.println();
        
        // ========================================
        // TEIL 2: Polymorphie — eine Variable, viele Formen
        // ========================================
        
        System.out.println("═══ TEIL 2: Polymorphie in Aktion ═══");
        System.out.println();
        
        // Eine Variable vom Eltern-Typ...
        Fahrzeug f;
        
        // ...kann verschiedene Kind-Objekte halten!
        f = new Auto("VW Golf", 2024, 4);
        System.out.println();
        f.fahren(50);  // → Auto-Verhalten!
        
        System.out.println();
        
        f = new Motorrad("Harley Davidson", 2023, 1200, "Chopper");
        System.out.println();
        f.fahren(50);  // → Motorrad-Verhalten!
        
        System.out.println();
        
        f = new LKW("MAN", 2022, 15000);
        System.out.println();
        f.fahren(50);  // → LKW-Verhalten!
        
        System.out.println();
        
        // ========================================
        // TEIL 3: Polymorphie mit Collection
        // ========================================
        
        System.out.println("═══ TEIL 3: Polymorphie mit Collection ═══");
        System.out.println();
        
        // Fuhrpark mit verschiedenen Fahrzeugen
        List<Fahrzeug> fuhrpark = new ArrayList<>();
        fuhrpark.add(new Auto("BMW X5", 2023, 5));
        fuhrpark.add(new Motorrad("Kawasaki", 2022, 600, "Sportler"));
        fuhrpark.add(new LKW("Volvo", 2021, 20000));
        fuhrpark.add(new Auto("Audi A3", 2024, 4));
        
        System.out.println();
        System.out.println("Alle Fahrzeuge fahren 100 km:");
        System.out.println("─────────────────────────────────");
        
        for (Fahrzeug fahrzeug : fuhrpark) {
            fahrzeug.fahren(100);  // Jeder fährt auf seine Art!
        }
        
        System.out.println();
        
        // ========================================
        // TEIL 4: Methoden überschreiben
        // ========================================
        
        System.out.println("═══ TEIL 4: @Override Beispiel ═══");
        System.out.println();
        
        LKW lkw = new LKW("Mercedes", 2023, 18000);
        System.out.println();
        
        System.out.println("LKW leer — normales Bremsen:");
        lkw.bremsen();  // Standard
        
        System.out.println();
        lkw.beladen();
        
        System.out.println("LKW beladen — schweres Bremsen:");
        lkw.bremsen();  // Überschrieben!
        
        System.out.println();
        
        // ========================================
        // TEIL 5: Info-Methode (geerbt, nicht überschrieben)
        // ========================================
        
        System.out.println("═══ TEIL 5: Geerbte Methode ═══");
        System.out.println();
        
        Auto bmw = new Auto("BMW M3", 2024, 2);
        System.out.println();
        bmw.fahren(1500);
        bmw.info();  // Geerbte Methode — nicht überschrieben
        
        System.out.println();
        System.out.println("✅ Tag 7 geschafft!");
        System.out.println();
        
        // ========================================
        // AUFGABE
        // ========================================
        
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║                  DEINE AUFGABE                    ║");
        System.out.println("╠═══════════════════════════════════════════════════╣");
        System.out.println("║ Erstelle eine Mitarbeiter-Hierarchie:             ║");
        System.out.println("║                                                   ║");
        System.out.println("║ abstract class Mitarbeiter:                       ║");
        System.out.println("║ - name, personalnummer, gehalt                    ║");
        System.out.println("║ - arbeiten() → \"Name arbeitet.\"                   ║");
        System.out.println("║ - getJahresgehalt() → gehalt * 12                 ║");
        System.out.println("║ - abstract getRolle()                             ║");
        System.out.println("║                                                   ║");
        System.out.println("║ class Entwickler extends Mitarbeiter:             ║");
        System.out.println("║ - programmiersprache                              ║");
        System.out.println("║ - @Override arbeiten() → \"programmiert in...\"     ║");
        System.out.println("║                                                   ║");
        System.out.println("║ class Manager extends Mitarbeiter:                ║");
        System.out.println("║ - teamgroesse                                     ║");
        System.out.println("║ - @Override getJahresgehalt() → +10% Bonus        ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Lösung: Anfang Tag 8!                             ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
    }
}
