package de.javafleet.oop.model;

/**
 * Auto-Klasse — Konkrete Kindklasse von Fahrzeug.
 * 
 * Demonstriert:
 * - extends (Vererbung)
 * - @Override (Methode überschreiben)
 * - super() (Eltern-Konstruktor aufrufen)
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Auto extends Fahrzeug {
    
    // ========================================
    // ZUSÄTZLICHE ATTRIBUTE
    // ========================================
    
    private int anzahlTueren;
    
    // ========================================
    // KONSTRUKTOR
    // ========================================
    
    /**
     * Erstellt ein neues Auto.
     * 
     * @param marke Die Marke
     * @param baujahr Das Baujahr
     * @param anzahlTueren Anzahl der Türen (2-5)
     */
    public Auto(String marke, int baujahr, int anzahlTueren) {
        super(marke, baujahr);  // Eltern-Konstruktor!
        
        if (anzahlTueren < 2 || anzahlTueren > 5) {
            throw new IllegalArgumentException("Türen müssen 2-5 sein!");
        }
        
        this.anzahlTueren = anzahlTueren;
        System.out.println("✓ Auto erstellt: " + anzahlTueren + "-Türer");
    }
    
    // ========================================
    // ÜBERSCHRIEBENE METHODE (POLYMORPHIE!)
    // ========================================
    
    /**
     * Auto-spezifisches Fahren.
     */
    @Override
    public void fahren(int km) {
        if (km < 0) {
            throw new IllegalArgumentException("Kilometer dürfen nicht negativ sein!");
        }
        kilometerstand += km;
        System.out.println("🚗 " + marke + " fährt " + km + " km auf der Straße.");
    }
    
    // ========================================
    // EIGENE METHODEN
    // ========================================
    
    /**
     * Auto hupt.
     */
    public void hupen() {
        System.out.println("🔊 " + marke + ": HUUUP!");
    }
    
    /**
     * Kofferraum öffnen.
     */
    public void kofferraumOeffnen() {
        System.out.println("📦 Kofferraum von " + marke + " wird geöffnet.");
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public int getAnzahlTueren() { return anzahlTueren; }
}
