package de.javafleet.oop.model;

/**
 * Abstrakte Fahrzeug-Klasse — Template für alle Fahrzeuge.
 * 
 * Demonstriert:
 * - abstract class (kann nicht instanziiert werden)
 * - abstract method (muss von Kindklassen implementiert werden)
 * - protected Attribute (sichtbar für Kindklassen)
 * 
 * @author Nova Trent
 * @version 1.0
 */
public abstract class Fahrzeug {
    
    // ========================================
    // PROTECTED ATTRIBUTE (für Kindklassen)
    // ========================================
    
    protected String marke;
    protected int baujahr;
    protected int kilometerstand;
    
    // ========================================
    // KONSTRUKTOR
    // ========================================
    
    /**
     * Konstruktor für Fahrzeug.
     * Wird von Kindklassen mit super() aufgerufen.
     * 
     * @param marke Die Marke des Fahrzeugs
     * @param baujahr Das Baujahr
     */
    public Fahrzeug(String marke, int baujahr) {
        if (marke == null || marke.isBlank()) {
            throw new IllegalArgumentException("Marke darf nicht leer sein!");
        }
        if (baujahr < 1886 || baujahr > 2030) {
            throw new IllegalArgumentException("Ungültiges Baujahr: " + baujahr);
        }
        
        this.marke = marke;
        this.baujahr = baujahr;
        this.kilometerstand = 0;
        
        System.out.println("✓ Fahrzeug-Basis initialisiert: " + marke + " (" + baujahr + ")");
    }
    
    // ========================================
    // ABSTRAKTE METHODE
    // ========================================
    
    /**
     * Fährt eine bestimmte Strecke.
     * MUSS von jeder Kindklasse implementiert werden!
     * 
     * @param km Kilometer
     */
    public abstract void fahren(int km);
    
    // ========================================
    // NORMALE METHODEN
    // ========================================
    
    /**
     * Zeigt Info über das Fahrzeug.
     */
    public void info() {
        System.out.println("┌─────────────────────────────────────┐");
        System.out.println("│ " + String.format("%-35s", marke) + " │");
        System.out.println("├─────────────────────────────────────┤");
        System.out.println("│ Baujahr:   " + String.format("%-24d", baujahr) + " │");
        System.out.println("│ Kilometer: " + String.format("%-24d", kilometerstand) + " │");
        System.out.println("└─────────────────────────────────────┘");
    }
    
    /**
     * Bremst das Fahrzeug.
     */
    public void bremsen() {
        System.out.println("🛑 " + marke + " bremst.");
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public String getMarke() { return marke; }
    public int getBaujahr() { return baujahr; }
    public int getKilometerstand() { return kilometerstand; }
}
