package de.javafleet.oop.model;

/**
 * LKW-Klasse — Weitere Kindklasse von Fahrzeug.
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class LKW extends Fahrzeug {
    
    // ========================================
    // ZUSÄTZLICHE ATTRIBUTE
    // ========================================
    
    private int ladekapazitaetKg;
    private boolean istBeladen;
    
    // ========================================
    // KONSTRUKTOR
    // ========================================
    
    /**
     * Erstellt einen neuen LKW.
     * 
     * @param marke Die Marke
     * @param baujahr Das Baujahr
     * @param ladekapazitaetKg Maximale Ladekapazität in kg
     */
    public LKW(String marke, int baujahr, int ladekapazitaetKg) {
        super(marke, baujahr);
        
        if (ladekapazitaetKg < 1000 || ladekapazitaetKg > 50000) {
            throw new IllegalArgumentException("Ladekapazität muss 1000-50000 kg sein!");
        }
        
        this.ladekapazitaetKg = ladekapazitaetKg;
        this.istBeladen = false;
        System.out.println("✓ LKW erstellt: " + ladekapazitaetKg + " kg Kapazität");
    }
    
    // ========================================
    // ÜBERSCHRIEBENE METHODE (POLYMORPHIE!)
    // ========================================
    
    @Override
    public void fahren(int km) {
        if (km < 0) {
            throw new IllegalArgumentException("Kilometer dürfen nicht negativ sein!");
        }
        kilometerstand += km;
        
        if (istBeladen) {
            System.out.println("🚛 " + marke + " LKW rollt " + km + " km schwer beladen.");
        } else {
            System.out.println("🚛 " + marke + " LKW fährt " + km + " km (leer).");
        }
    }
    
    /**
     * LKW bremst — überschrieben wegen längerer Bremsweg.
     */
    @Override
    public void bremsen() {
        if (istBeladen) {
            System.out.println("🛑 " + marke + " LKW bremst SCHWER! Langer Bremsweg!");
        } else {
            super.bremsen();  // Standard-Bremsung
        }
    }
    
    // ========================================
    // EIGENE METHODEN
    // ========================================
    
    /**
     * Belädt den LKW.
     */
    public void beladen() {
        istBeladen = true;
        System.out.println("📦 " + marke + " wird beladen...");
    }
    
    /**
     * Entlädt den LKW.
     */
    public void entladen() {
        istBeladen = false;
        System.out.println("📭 " + marke + " wird entladen...");
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public int getLadekapazitaetKg() { return ladekapazitaetKg; }
    public boolean isIstBeladen() { return istBeladen; }
}
