package de.javafleet.oop.model;

/**
 * Motorrad-Klasse — Lösung der Tag 6 Challenge!
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Motorrad extends Fahrzeug {
    
    // ========================================
    // ZUSÄTZLICHE ATTRIBUTE
    // ========================================
    
    private int hubraum;
    private String typ;  // Chopper, Sportler, Tourer, etc.
    
    // ========================================
    // KONSTRUKTOR
    // ========================================
    
    /**
     * Erstellt ein neues Motorrad.
     * 
     * @param marke Die Marke
     * @param baujahr Das Baujahr
     * @param hubraum Hubraum in ccm
     * @param typ Typ (Chopper, Sportler, etc.)
     */
    public Motorrad(String marke, int baujahr, int hubraum, String typ) {
        super(marke, baujahr);
        
        if (hubraum < 50 || hubraum > 2500) {
            throw new IllegalArgumentException("Hubraum muss 50-2500 ccm sein!");
        }
        
        this.hubraum = hubraum;
        this.typ = typ != null ? typ : "Standard";
        System.out.println("✓ Motorrad erstellt: " + typ + " (" + hubraum + " ccm)");
    }
    
    // ========================================
    // ÜBERSCHRIEBENE METHODE (POLYMORPHIE!)
    // ========================================
    
    @Override
    public void fahren(int km) {
        if (km < 0) {
            throw new IllegalArgumentException("Kilometer dürfen nicht negativ sein!");
        }
        kilometerstand += km;
        System.out.println("🏍️ " + marke + " " + typ + " kurvt " + km + " km.");
    }
    
    // ========================================
    // EIGENE METHODEN
    // ========================================
    
    /**
     * Macht einen Wheelie.
     */
    public void wheelie() {
        if (hubraum < 250) {
            System.out.println("⚠️ " + marke + " ist zu schwach für einen Wheelie!");
        } else {
            System.out.println("🏍️ " + marke + " macht einen Wheelie! 🔥");
        }
    }
    
    /**
     * Drosselt das Motorrad.
     */
    public void drosseln(int aufKW) {
        System.out.println("⚙️ " + marke + " wird auf " + aufKW + " kW gedrosselt.");
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public int getHubraum() { return hubraum; }
    public String getTyp() { return typ; }
}
