# Java OOP - Tag 8: Typumwandlung & instanceof

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 8 von 10  
**Thema:** Upcast, Downcast, instanceof, Pattern Matching  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

```bash
cd Tag08_Typumwandlung
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag08_Typumwandlung/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java
        └── model/
            ├── Fahrzeug.java
            ├── Auto.java
            ├── Motorrad.java
            ├── Mitarbeiter.java    (Lösung Tag 7)
            ├── Entwickler.java
            └── Manager.java
```

---

## 📝 Was dieses Projekt demonstriert

### Upcast (automatisch)
```java
Auto auto = new Auto("VW", 2024);
Fahrzeug f = auto;  // ✅ Kein Cast nötig
```

### Downcast (explizit)
```java
Auto a = (Auto) f;  // ⚠️ Expliziter Cast
a.hupen();
```

### instanceof Prüfung
```java
if (f instanceof Auto) {
    Auto a = (Auto) f;  // Sicher!
}
```

### Pattern Matching (Java 16+)
```java
if (f instanceof Auto a) {
    a.hupen();  // Prüfen + Casten in einem!
}
```

---

## 🎯 Lernziele

- ✅ Upcast verstehen (Kind → Eltern, automatisch)
- ✅ Downcast anwenden (Eltern → Kind, explizit)
- ✅ instanceof für sichere Typprüfung nutzen
- ✅ Pattern Matching für eleganten Code

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
